/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.device;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import org.tizen.ecp.DynamicLoader;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.device.Device;
import org.tizen.ecp.ecpinfo.xmls.CardImagesType;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;
import org.tizen.ecp.ecpinfo.xmls.PopupSizeType;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.card.ECPCardPane;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class DeviceManager {
    private static DeviceManager instance = new DeviceManager();
    private static Logger logger = LogUtil.getECPLogger(DeviceManager.class).getLogger();
    private final Map<String, Device> deviceMap = new HashMap<String, Device>();
    private final List<String> deviceList = new ArrayList<String>();
    private final Map<String, ECPCardPane> cardClass = new HashMap<String, ECPCardPane>();
    private List<String> capList = new ArrayList<String>();
    private List<CapList> capDeviceList = new ArrayList<CapList>();
    private static int capacity = 0;

    public static DeviceManager getInstance() {
        return instance;
    }

    public void initialize() {
        ECPCardPane cardPane = null;
        List<DeviceType> devices = ECPInfo.getInstance().getDevice();
        if (devices == null) {
            return;
        }
        String prof = ECPInfo.getInstance().getParentProfile();
        for (DeviceType dev : devices) {
            String name = dev.getName();
            if (name == null || name.isEmpty() || dev.getCardImpl() == null && dev.getPopupImpl() == null && prof != null && (dev = ECPInfo.getInstance().getExtDevice(name)) == null) continue;
            Device device = new Device(name);
            device.setTitle(dev.getTitle());
            String popupTitle = dev.getPopupTitle();
            if (popupTitle != null && !popupTitle.isEmpty()) {
                device.setPopupTitle(popupTitle);
            }
            device.setCardImpl(dev.getCardImpl());
            CardImagesType images = dev.getCardImages();
            if (images != null) {
                device.setNormalImage(images.getNormal());
                device.setHoverImage(images.getHover());
                device.setSelectedImage(images.getSelected());
                device.setActiveImage(images.getActive());
                device.setDimImage(images.getDim());
            }
            if (dev.isCapabilityCheck() != null) {
                device.setCapability(dev.isCapabilityCheck());
            }
            device.setShortcut(dev.getCardShortcut());
            device.setPopupImpl(dev.getPopupImpl());
            PopupSizeType sizes = dev.getPopupSize();
            if (sizes != null) {
                device.setPopupWidth(sizes.getWidth());
                device.setPopupHeight(sizes.getHeight());
            }
            if (dev.getCapabilityCheckBit() != null) {
                this.capDeviceList.add(new CapList(dev.getCapabilityCheckBit(), name));
            }
            this.deviceMap.put(name, device);
            this.deviceList.add(name);
        }
        for (String name : this.deviceList) {
            Device dev = this.deviceMap.get(name);
            String card = dev.getCardImpl();
            String popup = dev.getPopupImpl();
            String title = dev.getTitle();
            if (title == null || title.isEmpty()) {
                title = name;
            }
            if (card != null && !card.isEmpty()) {
                try {
                    cardPane = this.loadClass(ECPCardPane.class, card);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.log(Level.SEVERE, "Card class loading fail", e);
                    continue;
                }
                cardPane.setTitle(title);
            } else if (popup != null && !popup.isEmpty()) {
                ECPPopupPane popupPane = null;
                try {
                    popupPane = this.loadClass(ECPPopupPane.class, popup);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.log(Level.SEVERE, "Popup class loading fail", e);
                    continue;
                }
                cardPane = new ECPCardPane(name, title, dev.getPopupWidth(), dev.getPopupHeight(), popupPane);
                if (dev.getPopupTitle() != null) {
                    title = dev.getPopupTitle();
                }
                popupPane.setIdentity(name, title);
            } else {
                logger.severe("ECP XML is corrupted. please check it.");
                continue;
            }
            Image normal = this.loadImage(name, dev.getNormalImage());
            Image hover = this.loadImage(name, dev.getHoverImage());
            Image selected = this.loadImage(name, dev.getSelectedImage());
            Image active = this.loadImage(name, dev.getActiveImage());
            Image dim = this.loadImage(name, dev.getDimImage());
            cardPane.setImages(normal, hover, selected, active, dim);
            cardPane.setCapability(dev.isCapability());
            String shortcut = dev.getShortcut();
            if (shortcut != null && shortcut.length() > 0) {
                cardPane.setShortcut(dev.getShortcut().substring(0, 1));
            }
            this.cardClass.put(name, cardPane);
        }
    }

    private <T> T loadClass(Class<T> cls, String card) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> dp = DynamicLoader.getClassLoader().loadClass(card);
        assert (dp != null);
        Object view = dp.newInstance();
        return (T)view;
    }

    private Image loadImage(String name, String file) {
        Image image = null;
        InputStream is = DynamicLoader.getClassLoader().getResourceAsStream(name + "/" + file);
        assert (is != null);
        if (is != null) {
            image = new Image(is);
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return image;
    }

    public List<String> getDeviceList() {
        return this.deviceList;
    }

    public ECPCardPane getDevice(String device) {
        return this.cardClass.get(device);
    }

    public void reorderList(int from, int to) {
        this.deviceList.add(to, this.deviceList.get(from));
        this.deviceList.remove(from);
    }

    public void setCapabilities(String data) {
        this.capList.clear();
        try {
            capacity = Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            if (data != null && !data.isEmpty()) {
                logger.warning("Wrong data: " + data);
            }
            capacity = 0;
        }
        for (CapList list : this.capDeviceList) {
            if ((list.getCapacity() & capacity) != list.getCapacity()) continue;
            this.capList.add(list.getDevice());
        }
        for (String dev : this.deviceList) {
            Pane draw;
            ECPCardPane pane = this.getDevice(dev);
            if (pane == null || !pane.isCapability() || (draw = pane.getDrawPane()) == null) continue;
            if (this.capList.contains(dev)) {
                draw.setDisable(false);
                continue;
            }
            draw.setDisable(true);
        }
    }

    public List<String> getCapableDevices() {
        return this.capList;
    }

    public int getCapacity() {
        return capacity;
    }

    public class CapList {
        private int cap;
        private String device;

        CapList(int cap, String device) {
            this.cap = cap;
            this.device = device;
        }

        public int getCapacity() {
            return this.cap;
        }

        public String getDevice() {
            return this.device;
        }
    }
}

