/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views.card;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.views.ECPMainAction;
import org.tizen.ecp.views.card.ECPCardModel;
import org.tizen.ecp.views.popup.ECPPopupView;

public class ECPCardAction
implements Initializable {
    @FXML
    public AnchorPane anchorPane;
    @FXML
    public Label cardTitle;
    @FXML
    public ImageView cardImage;
    @FXML
    public Label cardValue;
    private Label shortcutLabel;
    private final ECPCardModel model;
    private final String titleLabelNormal = "-fx-text-fill: #585858; -fx-font-size: 140%; -fx-font-weight: bold;";
    private final String titleLabelActive = "-fx-text-fill: #FFFFFF; -fx-font-size: 140%; -fx-font-weight: bold;";
    private final String valueLabelNormal = "-fx-text-fill: #585858; -fx-font-size: 100%;";
    private final String valueLabelActive = "-fx-text-fill: #FFFFFF; -fx-font-size: 100%;";
    private final String normalStyle = "-fx-background-color: #f8f8f8;";
    private final String hoverStyle = "-fx-background-color: #D9D9D9;";
    private final String selectedStyle = "-fx-background-color: #006DE2;";
    private final String focusedStyle = "-fx-border-color:#008AEE;-fx-border-width:1;";
    private final String normalFocusedStyle = "-fx-background-color: #f8f8f8;-fx-border-color:#008AEE;-fx-border-width:1;";
    private final String hoverFocusedStyle = "-fx-background-color: #D9D9D9;-fx-border-color:#008AEE;-fx-border-width:1;";
    private final String selectedFocusedStyle = "-fx-background-color: #006DE2;-fx-border-color:#008AEE;-fx-border-width:1;";
    private final SimpleObjectProperty<STATE> stateProperty = new SimpleObjectProperty((Object)STATE.NORMAL);
    private final double SHORTCUT_POS_X = 8.0;
    private final double SHORTCUT_POS_Y = 10.0;
    private final Map<String, ECPPopupView> popupClass = new HashMap<String, ECPPopupView>();
    private double originX = 0.0;
    private static final int CLICK_THRESHHOLD = 5;

    public ECPCardAction(ECPCardModel model) {
        this.model = model;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cardTitle.textProperty().bind((ObservableValue)this.model.getTitle());
        Bindings.bindBidirectional((Property)this.cardImage.imageProperty(), this.model.getCardImage());
        this.cardImage.setFitWidth(70.0);
        this.cardImage.setFitHeight(70.0);
        this.cardValue.textProperty().bind((ObservableValue)this.model.getDescription());
        this.cardTitle.setStyle("-fx-text-fill: #585858; -fx-font-size: 140%; -fx-font-weight: bold;");
        this.cardValue.setStyle("-fx-text-fill: #585858; -fx-font-size: 100%;");
        this.anchorPane.setStyle("-fx-background-color: #f8f8f8;");
        this.shortcutLabel = new Label();
        this.shortcutLabel.setVisible(false);
        this.shortcutLabel.getStyleClass().add((Object)"shortcut");
        this.anchorPane.getChildren().add((Object)this.shortcutLabel);
        String shortcut = (String)this.model.getShortcut().get();
        if (shortcut != null && !shortcut.isEmpty()) {
            this.shortcutLabel.setText(shortcut.toUpperCase());
        }
        AnchorPane.setLeftAnchor((Node)this.shortcutLabel, (Double)8.0);
        AnchorPane.setTopAnchor((Node)this.shortcutLabel, (Double)10.0);
        ECPMainAction.shortcutVisibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean shortcutVisible) {
                if (shortcutVisible == null) {
                    return;
                }
                if (shortcutVisible.booleanValue()) {
                    if (!ECPCardAction.this.shortcutLabel.getText().isEmpty()) {
                        ECPCardAction.this.shortcutLabel.setVisible(true);
                    }
                } else {
                    ECPCardAction.this.shortcutLabel.setVisible(false);
                }
            }
        });
        this.anchorPane.setFocusTraversable(true);
        this.anchorPane.focusedProperty().addListener((observable, oldValue, isFocused) -> {
            if (!isFocused.booleanValue() && !this.model.hasDialog()) {
                this.stateProperty.set((Object)STATE.NORMAL);
            }
            this.redrawCard();
        });
        this.stateProperty.addListener((observable, oldState, newState) -> this.redrawCard());
        this.anchorPane.setOnKeyPressed(event -> {
            KeyCode keyCode = event.getCode();
            switch (keyCode) {
                case ENTER: 
                case SPACE: {
                    this.cardClicked();
                    break;
                }
            }
        });
    }

    private void redrawCard() {
        switch ((STATE)((Object)this.stateProperty.get())) {
            case HOVER: {
                this.model.setHoverImage();
                if (this.anchorPane.isFocused()) {
                    this.anchorPane.setStyle("-fx-background-color: #D9D9D9;-fx-border-color:#008AEE;-fx-border-width:1;");
                } else {
                    this.anchorPane.setStyle("-fx-background-color: #D9D9D9;");
                }
                this.cardTitle.setStyle("-fx-text-fill: #585858; -fx-font-size: 140%; -fx-font-weight: bold;");
                this.cardValue.setStyle("-fx-text-fill: #585858; -fx-font-size: 100%;");
                break;
            }
            case NORMAL: {
                if (this.model.hasDialog() || !this.model.getSelected().get()) {
                    this.model.setNormalImage();
                } else {
                    this.model.setActiveImage();
                }
                if (this.anchorPane.isFocused()) {
                    this.anchorPane.setStyle("-fx-background-color: #f8f8f8;-fx-border-color:#008AEE;-fx-border-width:1;");
                } else {
                    this.anchorPane.setStyle("-fx-background-color: #f8f8f8;");
                }
                this.cardTitle.setStyle("-fx-text-fill: #585858; -fx-font-size: 140%; -fx-font-weight: bold;");
                this.cardValue.setStyle("-fx-text-fill: #585858; -fx-font-size: 100%;");
                break;
            }
            case SELECT: {
                this.model.setActiveImage();
                if (this.anchorPane.isFocused()) {
                    this.anchorPane.setStyle("-fx-background-color: #006DE2;-fx-border-color:#008AEE;-fx-border-width:1;");
                } else {
                    this.anchorPane.setStyle("-fx-background-color: #006DE2;");
                }
                this.cardTitle.setStyle("-fx-text-fill: #FFFFFF; -fx-font-size: 140%; -fx-font-weight: bold;");
                this.cardValue.setStyle("-fx-text-fill: #FFFFFF; -fx-font-size: 100%;");
                break;
            }
        }
    }

    @FXML
    public void cardMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.stateProperty.set((Object)STATE.HOVER);
        } else if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.originX = event.getX();
            this.model.setSelectedImage();
        } else if (event.getEventType() == MouseEvent.MOUSE_CLICKED) {
            if (Math.abs(event.getX() - this.originX) < 5.0) {
                this.cardClicked();
            }
        } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.stateProperty.set((Object)STATE.NORMAL);
        }
    }

    private void cardClicked() {
        this.anchorPane.requestFocus();
        this.stateProperty.set((Object)STATE.SELECT);
        if (this.model.hasDialog()) {
            ECPPopupView popup;
            String deviceName = this.model.getName();
            if (this.popupClass.containsKey(deviceName)) {
                popup = this.popupClass.get(deviceName);
            } else {
                popup = new ECPPopupView();
                this.popupClass.put(deviceName, popup);
            }
            popup.showPopup(deviceName, this.model.getWidth(), this.model.getHeight(), this.model.getEcpPopupPane());
            this.stateProperty.set((Object)STATE.NORMAL);
        } else if (this.model.getSelected().get()) {
            this.model.selected(false);
        } else {
            this.model.selected(true);
        }
    }

    public void selectCard() {
        this.cardClicked();
    }

    public Pane getRootPane() {
        return this.anchorPane;
    }

    static enum STATE {
        NORMAL,
        HOVER,
        SELECT;

    }
}

