/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.about;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.LogUtil;

public class About {
    private static About about = null;
    private String version = "";
    private String about_version = "";
    private String time = "";
    private String gitVersion = "";
    private String contents = "";
    private String ecpVersion = "";
    private String workspace = "";
    public static final String PROP_KEY_VERSION = "version";
    public static final String PROP_KEY_BUILD_TIME = "build_time";
    public static final String PROP_KEY_GIT_VERSION = "build_git_commit";
    public static final String ECP_VERSION = "ecp-version";
    private Logger logger = LogUtil.getECPLogger(About.class).getLogger();

    public static About getInstance() {
        if (about == null) {
            about = new About();
        }
        return about;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private About() {
        Path workspacePath = FilePath.getInstance().getVmsPath();
        this.workspace = workspacePath == null ? "undefined" : workspacePath.toString();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("about.properties");
        Properties properties = new Properties();
        String ver = null;
        if (in != null) {
            try {
                properties.load(in);
                ver = properties.getProperty(PROP_KEY_VERSION);
                this.time = properties.getProperty(PROP_KEY_BUILD_TIME);
                this.gitVersion = properties.getProperty(PROP_KEY_GIT_VERSION);
                this.ecpVersion = properties.getProperty(ECP_VERSION);
            }
            catch (IOException e1) {
                this.logger.log(Level.SEVERE, e1.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(FilePath.getInstance().getSDKRootPath() + File.separator + "sdk.version");
            Properties props = new Properties();
            props.load(fis);
            ver = props.getProperty("TIZEN_SDK_VERSION");
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, e.getMessage());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        if (ver == null) {
            this.about_version = "undefined";
            this.version = "undefined";
        } else if (ver.indexOf(40) == -1) {
            this.about_version = this.version = ver;
        } else {
            int start = ver.indexOf(40);
            int end = ver.indexOf(41);
            this.version = ver.substring(0, start);
            this.about_version = ver.substring(start + 1, end);
        }
        if (this.time.isEmpty() || this.time.contains(PROP_KEY_BUILD_TIME)) {
            this.time = "undefined";
        }
        if (this.gitVersion.isEmpty() || this.gitVersion.contains(PROP_KEY_GIT_VERSION)) {
            this.gitVersion = "undefined";
        }
        if (this.ecpVersion == null || this.ecpVersion.isEmpty()) {
            this.ecpVersion = "undefined";
        }
        this.contents = "Version: " + this.about_version + StringResources.NEW_LINE + "Build time: " + this.time + " (GMT)" + StringResources.NEW_LINE + "Git version: " + this.gitVersion + StringResources.NEW_LINE + "Workspace path: " + this.workspace + StringResources.NEW_LINE + "Package version: " + this.ecpVersion;
    }

    public void printSystemInformation() {
        String systemInfo = "";
        systemInfo = systemInfo + "JAVA HOME: " + System.getProperty("java.home") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "JAVA VENDOR: " + System.getProperty("java.vendor") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "JAVA VERSION: " + System.getProperty("java.version") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "OS ARCH: " + System.getProperty("os.arch") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "OS NAME: " + System.getProperty("os.name") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "OS VERSION: " + System.getProperty("os.version") + StringResources.NEW_LINE;
        this.logger.info("System Information" + StringResources.NEW_LINE + systemInfo);
        this.logger.info("EmulatorManager Information" + StringResources.NEW_LINE + this.contents);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.time;
    }

    public String getGitVersion() {
        return this.gitVersion;
    }

    public String getWorkspacePath() {
        return this.workspace;
    }

    public String getAboutVersion() {
        return this.about_version;
    }

    public String getEcpVersion() {
        return this.ecpVersion;
    }
}

