/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.dialog;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.CheckReturn;
import org.tizen.ecp.dialog.Dialog;

public class MessageBox {
    public static ButtonType confirm(String message) {
        return MessageBox.confirm("Emulator Control Panel", message, ButtonType.OK);
    }

    public static ButtonType info(String title, String message) {
        return MessageBox.open(title, message, ButtonType.OK);
    }

    public static ButtonType open(String title, String message, ButtonType ... types) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        for (ButtonType type : types) {
            dialog.getDialogPane().addButonType(type);
        }
        return (ButtonType)dialog.showAndWait();
    }

    public static ButtonType confirm(String title, String message) {
        return MessageBox.confirm(title, message, ButtonType.OK);
    }

    public static ButtonType confirm(String message, ButtonType type) {
        return MessageBox.confirm("Emulator Control Panel", message, type);
    }

    public static ButtonType confirm(String title, String message, ButtonType type) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        dialog.getDialogPane().addButonType(type);
        return (ButtonType)dialog.showAndWait();
    }

    public static ButtonType error(String message) {
        return MessageBox.error("Emulator Control Panel", message);
    }

    public static ButtonType error(String title, String message) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().addButonType(ButtonType.OK);
        return (ButtonType)dialog.showAndWait();
    }

    public static CheckReturn check(String message, String checkMessage, boolean isChecked, ButtonType ... types) {
        return MessageBox.check("Emulator Control Panel", message, checkMessage, isChecked, types);
    }

    public static CheckReturn check(String message, String checkMessage, ButtonType ... types) {
        return MessageBox.check("Emulator Control Panel", message, checkMessage, true, types);
    }

    public static CheckReturn check(String title, String message, String checkMessage, boolean isChecked, ButtonType ... types) {
        Dialog<CheckReturn> dialog = new Dialog<CheckReturn>();
        VBox content = new VBox();
        content.getStyleClass().add((Object)"content-pane");
        Label labMsg = new Label(message);
        labMsg.getStyleClass().add((Object)"content-label");
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(20.0, 20.0, 15.0, 15.0));
        final CheckBox checkBox = new CheckBox(checkMessage);
        checkBox.setSelected(isChecked);
        grid.add((Node)checkBox, 1, 1);
        content.getChildren().add((Object)labMsg);
        content.getChildren().add((Object)grid);
        content.layout();
        dialog.getDialogPane().setContent((Node)content);
        dialog.setTitle(title);
        for (ButtonType type : types) {
            dialog.getDialogPane().addButonType(type);
        }
        dialog.setResultConverter(new Callback<ButtonType, CheckReturn>(){

            public CheckReturn call(ButtonType param) {
                CheckReturn re = new CheckReturn();
                re.setButtonType(param);
                re.setChecked(checkBox.isSelected());
                return re;
            }
        });
        return (CheckReturn)dialog.showAndWait();
    }
}

