/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.dialog;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import org.tizen.ecp.dialog.ButtonBar;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.Dialog;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;

public class DialogPane {
    private final BorderPane mainPane;
    private final GridPane contentPane;
    private final Label contentLabel;
    private final ButtonBar buttonBar;
    private static Node detailsButton;
    private final ObservableList<ButtonType> buttons = FXCollections.observableArrayList();
    private final Map<ButtonType, Button> buttonNodes = new WeakHashMap<ButtonType, Button>();
    private Dialog<?> dialog;
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> contentRef;
        {
            this.contentRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node oldContent = (Node)this.contentRef.get();
            if (oldContent != null) {
                DialogPane.this.contentPane.getChildren().remove((Object)oldContent);
            }
            Node newContent = DialogPane.this.getContent();
            this.contentRef = new WeakReference<Node>(newContent);
            DialogPane.this.updateContentArea();
        }
    };
    private final StringProperty contentText = new SimpleStringProperty(this, "contentText"){

        protected void invalidated() {
            DialogPane.this.updateContentArea();
            DialogPane.this.mainPane.requestLayout();
        }
    };
    private final ObjectProperty<Node> expandableContentProperty = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> expandableContentRef;
        {
            this.expandableContentRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node oldExpandableContent = (Node)this.expandableContentRef.get();
            if (oldExpandableContent != null) {
                DialogPane.this.mainPane.getChildren().remove((Object)oldExpandableContent);
            }
            Node newExpandableContent = DialogPane.this.getExpandableContent();
            this.expandableContentRef = new WeakReference<Node>(newExpandableContent);
            if (newExpandableContent != null) {
                newExpandableContent.setVisible(DialogPane.this.isExpanded());
                newExpandableContent.setManaged(DialogPane.this.isExpanded());
                if (!newExpandableContent.getStyleClass().contains((Object)"expandable-content")) {
                    newExpandableContent.getStyleClass().add((Object)"expandable-content");
                }
                DialogPane.this.updateContentArea();
            }
        }
    };
    private final BooleanProperty expandedProperty = new SimpleBooleanProperty(this, "expanded", false){

        protected void invalidated() {
            Node expandableContent = DialogPane.this.getExpandableContent();
            if (expandableContent != null) {
                expandableContent.setVisible(DialogPane.this.isExpanded());
                expandableContent.setManaged(DialogPane.this.isExpanded());
            }
            DialogPane.this.mainPane.requestLayout();
            DialogPane.this.dialog.sizeToScene();
        }
    };
    private static ImageView downImage;
    private static ImageView upImage;
    private ButtonBar bBar = null;
    private static final int BUTTON_BAR_PREF_HEIGHT = 61;

    public DialogPane() {
        this.mainPane = new BorderPane();
        this.mainPane.setMinSize(300.0, 100.0);
        this.contentPane = new GridPane();
        this.contentPane.getStyleClass().add((Object)"content-pane");
        this.mainPane.setCenter((Node)this.contentPane);
        this.contentLabel = new Label();
        this.contentLabel.getStyleClass().add((Object)"content-label");
        this.contentPane.add((Node)this.contentLabel, 0, 0);
        this.buttonBar = this.createButtonBar();
        if (this.buttonBar != null) {
            this.mainPane.setBottom((Node)this.buttonBar.getButtonPanel());
        }
        this.buttons.addListener((ListChangeListener)new ListChangeListener<ButtonType>(){

            public void onChanged(ListChangeListener.Change<? extends ButtonType> c) {
                while (c.next()) {
                    if (c.wasRemoved()) {
                        for (ButtonType cmd : c.getRemoved()) {
                            DialogPane.this.buttonNodes.remove(cmd);
                        }
                    }
                    if (!c.wasAdded()) continue;
                    for (ButtonType cmd : c.getAddedSubList()) {
                        if (DialogPane.this.buttonNodes.containsKey(cmd)) continue;
                        DialogPane.this.buttonNodes.put(cmd, DialogPane.this.createButton(cmd));
                    }
                }
                DialogPane.this.updateButtons(DialogPane.this.buttonBar);
            }
        });
    }

    void setDialog(Dialog<?> dialog) {
        this.dialog = dialog;
    }

    public Pane getPane() {
        return this.mainPane;
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final void setContent(Node content) {
        this.content.setValue((Object)content);
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setContentText(String contentText) {
        this.contentText.set((Object)contentText);
    }

    public final String getContentText() {
        return (String)this.contentText.get();
    }

    public final StringProperty contentTextProperty() {
        return this.contentText;
    }

    public final ObjectProperty<Node> expandableContentProperty() {
        return this.expandableContentProperty;
    }

    public final Node getExpandableContent() {
        return (Node)this.expandableContentProperty.get();
    }

    public final void setExpandableContent(Node content) {
        this.expandableContentProperty.set((Object)content);
    }

    public final BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public final boolean isExpanded() {
        return this.expandedProperty().get();
    }

    public final void setExpanded(boolean value) {
        this.expandedProperty().set(value);
    }

    protected Node createDetailsButton() {
        final DetailsButton detailsButton = new DetailsButton();
        InvalidationListener expandedListener = new InvalidationListener(){

            public void invalidated(Observable arg) {
                boolean isExpanded = DialogPane.this.isExpanded();
                detailsButton.pseudoClassStateChanged(isExpanded ? "less" : "more");
                detailsButton.setGraphic((Node)(isExpanded ? upImage : downImage));
            }
        };
        expandedListener.invalidated(null);
        this.expandedProperty().addListener(expandedListener);
        detailsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                DialogPane.this.setExpanded(!DialogPane.this.isExpanded());
            }
        });
        detailsButton.getStyleClass().add((Object)"detail-button");
        return detailsButton;
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.buttons;
    }

    public final Node lookupButton(ButtonType buttonType) {
        return (Node)this.buttonNodes.get(buttonType);
    }

    public final void addButonType(ButtonType buttonType) {
        if (this.lookupButton(buttonType) == null) {
            this.buttons.add((Object)buttonType);
        }
    }

    public Button getButton(ButtonType buttonType) {
        if (this.bBar == null) {
            return null;
        }
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        for (Node node : this.bBar.getButtons()) {
            ButtonBar.ButtonData data = ButtonBar.getButtonData(node);
            if (data == null || !data.getTypeCode().equals(buttonData.getTypeCode())) continue;
            return (Button)node;
        }
        return null;
    }

    protected ButtonBar createButtonBar() {
        HBox hbox = new HBox();
        hbox.getStyleClass().add((Object)"button-bar");
        this.bBar = new ButtonBar(hbox, 61);
        this.bBar.getButtonPanel().setMaxWidth(Double.MAX_VALUE);
        this.updateButtons(this.bBar);
        return this.bBar;
    }

    protected Button createButton(final ButtonType buttonType) {
        Button button = new Button(buttonType.getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        ButtonBar.setButtonData((Node)button, buttonData);
        button.setDefaultButton(buttonData.isDefaultButton());
        button.setCancelButton(buttonData.isCancelButton());
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                if (DialogPane.this.dialog != null) {
                    DialogPane.this.dialog.impl_setResultAndClose(buttonType, true);
                }
            }
        });
        return button;
    }

    private void updateButtons(ButtonBar buttonBar) {
        boolean hasDefault = false;
        if (this.getExpandableContent() != null) {
            if (detailsButton == null) {
                detailsButton = this.createDetailsButton();
            }
            buttonBar.getButtons().add((Object)detailsButton);
            ButtonBar.setButtonData(detailsButton, ButtonBar.ButtonData.HELP_2);
        }
        for (ButtonType cmd : this.getButtonTypes()) {
            Button button = this.buttonNodes.put(cmd, this.createButton(cmd));
            ButtonBar.ButtonData buttonType = cmd.getButtonData();
            button.setDefaultButton(!hasDefault && buttonType.isDefaultButton());
            button.setCancelButton(buttonType.isCancelButton());
            hasDefault |= buttonType.isDefaultButton();
            buttonBar.getButtons().add((Object)button);
        }
        buttonBar.layoutButtons();
    }

    private void updateContentArea() {
        Node content;
        Node exContent = this.getExpandableContent();
        if (exContent != null && !this.contentPane.getChildren().contains((Object)exContent)) {
            this.contentPane.add(exContent, 0, 1);
        }
        if ((content = this.getContent()) != null) {
            if (!this.contentPane.getChildren().contains((Object)content)) {
                this.contentPane.add(content, 0, 0);
            }
            if (!content.getStyleClass().contains((Object)"content")) {
                content.getStyleClass().add((Object)"content");
            }
            content.setVisible(true);
            GridPane.setMargin((Node)content, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            GridPane.setVgrow((Node)content, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            this.contentLabel.setVisible(false);
            this.contentPane.autosize();
        } else {
            String contentText = this.getContentText();
            boolean visible = contentText != null && !contentText.isEmpty();
            this.contentLabel.setText(visible ? contentText : "");
            this.contentLabel.setVisible(visible);
            this.contentLabel.setManaged(visible);
            this.contentLabel.setMinHeight(100.0);
            this.contentPane.autosize();
        }
    }

    static {
        downImage = Images.getImageView(ImageKind.ICON_DIALOG_DETAIL_DOWN);
        upImage = Images.getImageView(ImageKind.ICON_DIALOG_DETAIL_UP);
    }

    private static class DetailsButton
    extends Hyperlink {
        private DetailsButton() {
        }

        private void pseudoClassStateChanged(String pseudoClass) {
        }
    }
}

