/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views.card;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import org.json.simple.JSONObject;
import org.tizen.ecp.interfaces.ICardSelection;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.views.card.ECPCardAction;
import org.tizen.ecp.views.card.ECPCardModel;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class ECPCardPane
implements ILsn,
ICardSelection {
    protected String name = "";
    protected String title = "";
    protected boolean isDialog;
    protected ECPPopupPane ecpPane;
    protected int width;
    protected int height;
    protected Image normalImage;
    protected Image hoverImage;
    protected Image selectedImage;
    protected Image activeImage;
    protected Image dimImage;
    protected ECPCardModel model = new ECPCardModel();
    private boolean checkCapability = false;
    private Pane cardView = null;
    private ECPCardAction cardAction;

    public ECPCardPane() {
    }

    public ECPCardPane(String name, String title, int width, int height, ECPPopupPane popup) {
        this();
        this.isDialog = true;
        this.name = name;
        this.title = title;
        this.width = width;
        this.height = height;
        this.ecpPane = popup;
    }

    public Pane createView() {
        ECPFXMLLoader loader = new ECPFXMLLoader(this.getClass().getResource("/org/tizen/ecp/views/card/ECPCardPane.fxml"), this.model);
        try {
            this.cardView = (Pane)loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cardAction = (ECPCardAction)loader.getController();
        this.model.setName(this.name);
        this.model.setTitle(this.title);
        this.model.setDefaultImages(this.normalImage, this.hoverImage, this.selectedImage, this.activeImage, this.dimImage);
        this.model.setDialog(this.isDialog);
        this.model.setEcpPopupPane(this.ecpPane);
        this.model.setSize(this.width, this.height);
        this.model.addCardSelectionListener(this);
        if (this.ecpPane != null) {
            this.ecpPane.onCreate();
        }
        return this.cardView;
    }

    public void selected(boolean selection) {
        this.model.selected(selection, false);
        if (selection) {
            this.model.setActiveImage();
        } else {
            this.model.setNormalImage();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String desc) {
        this.model.setDescription(desc);
    }

    public void setImages(Image normal, Image hover, Image selected, Image active, Image dim) {
        if (normal == null) {
            return;
        }
        this.normalImage = normal;
        this.hoverImage = hover != null ? hover : normal;
        this.selectedImage = selected != null ? selected : normal;
        this.activeImage = active != null ? active : normal;
        this.dimImage = dim != null ? dim : normal;
    }

    public void setCapability(boolean enable) {
        this.checkCapability = enable;
    }

    public boolean isCapability() {
        return this.checkCapability;
    }

    public Pane getDrawPane() {
        return this.cardView;
    }

    public ECPCardAction getCardAction() {
        return this.cardAction;
    }

    public void setShortcut(String shortcut) {
        this.model.setShortcut(shortcut);
    }

    public String getShortcut() {
        return (String)this.model.getShortcut().get();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
    }

    @Override
    public void OnStatusEventProcPB(GeneratedMessage param) {
    }

    @Override
    public void cardSelectionChangedListener(boolean selected) {
    }

    public void onCreate() {
    }
}

