/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.utils;

import org.tizen.cli.CLIConstants;
import org.tizen.cli.CLIManager;
import org.tizen.ecp.resources.StringResources;

public class OutputUtil {
    public static void println() {
        System.out.println();
    }

    public static void print(String output) {
        System.out.print(output);
    }

    public static void println(String output) {
        System.out.println(output);
    }

    public static void printTabln(String output) {
        OutputUtil.println("\t" + output);
    }

    public static void printFormatList(String name, String value) {
        OutputUtil.println(OutputUtil.getFormatList(name, value));
    }

    public static String getFormatList(String name) {
        return String.format("\t%-13s%n", name);
    }

    public static String getFormatList(String name, String value) {
        return String.format("\t%-13s : %s%n", name, value);
    }

    public static void printVMInfo(String name, String target, String profile) {
        OutputUtil.println(String.format("\t%-10s %-15s %s", name, target, profile));
    }

    public static void printDeviceUsage(String device) {
        OutputUtil.print(OutputUtil.getDeviceUsage(device));
    }

    public static String getDeviceUsage(String device) {
        return CLIConstants.STRING_USAGE + (CLIManager.getInstance().getSessionMode() ? "" : "ecp-cli " + CLIConstants.STRING_TARGET) + " " + device + " " + CLIConstants.STRING_CMDS + StringResources.NEW_LINE + StringResources.NEW_LINE;
    }

    public static void printError(String desc) {
        OutputUtil.println(CLIConstants.ERR_PRINT + desc);
    }

    public static void printError(String desc, Exception e) {
        OutputUtil.printError(CLIConstants.ERR_PRINT + desc + "\"" + e.getMessage() + "\"");
    }

    public static void printError(String desc, String cause) {
        OutputUtil.println(CLIConstants.ERR_PRINT + desc + " " + "\"" + cause + "\"");
    }

    public static void printHelpError(String desc, String help) {
        OutputUtil.println(CLIConstants.ERR_PRINT + desc + StringResources.NEW_LINE + help);
    }

    public static void printOK() {
        OutputUtil.println(CLIConstants.OK_PRINT);
    }

    public static void printOK(String desc) {
        OutputUtil.println(CLIConstants.OK_PRINT + " : " + desc);
    }

    public static void printStatus(String key, String value) {
        OutputUtil.print(OutputUtil.getFormatList(key, value));
    }

    public static void printFail() {
        OutputUtil.println(CLIConstants.FAIL_PRINT);
    }

    public static String appendComplete(String des, String src) {
        return des + src;
    }

    public static void debug(String desc) {
        if (CLIConstants.DEBUG) {
            OutputUtil.println(desc);
        }
    }
}

