/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.dialog;

import com.sun.javafx.tk.Toolkit;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.tizen.ecp.EmulatorControlPanel;
import org.tizen.ecp.dialog.ButtonBar;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.DialogPane;
import org.tizen.ecp.dialog.InternalDialog;

public class Dialog<R> {
    private static final URL DIALOG_CSS_URL = EmulatorControlPanel.class.getResource("/org/tizen/ecp/dialog/dialog.css");
    final InternalDialog dialog;
    private boolean isClosing;
    private final ObjectProperty<DialogPane> dialogPane = new SimpleObjectProperty((Object)this, "dialogPane", (Object)new DialogPane());
    private final ObjectProperty<R> resultProperty = new SimpleObjectProperty<R>(){

        protected void invalidated() {
            Dialog.this.close();
        }
    };
    private final ObjectProperty<Callback<ButtonType, R>> resultConverterProperty = new SimpleObjectProperty((Object)this, "resultConverter");

    public static URL getDialogCssUrl() {
        return DIALOG_CSS_URL;
    }

    public Dialog() {
        this.dialog = new InternalDialog(this);
        this.dialog.initOwner(EmulatorControlPanel.getMainWindow());
        this.setDialogPane(new DialogPane());
        this.initModality(Modality.APPLICATION_MODAL);
    }

    public final void show() {
        Toolkit.getToolkit().checkFxUserThread();
        if (Double.isNaN(this.getWidth()) && Double.isNaN(this.getHeight())) {
            this.dialog.sizeToScene();
        }
        this.dialog.show();
    }

    public final R showAndWait() {
        Toolkit.getToolkit().checkFxUserThread();
        if (Double.isNaN(this.getWidth()) && Double.isNaN(this.getHeight())) {
            this.dialog.sizeToScene();
        }
        this.dialog.showAndWait();
        return this.getResult();
    }

    public final void close() {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        R result = this.getResult();
        if (result == null && !this.dialog.requestPermissionToClose(this)) {
            this.isClosing = false;
            return;
        }
        if (result == null) {
            ButtonType cancelButton = null;
            for (ButtonType button : this.getDialogPane().getButtonTypes()) {
                ButtonBar.ButtonData buttonData = button.getButtonData();
                if (buttonData == null) continue;
                if (buttonData == ButtonBar.ButtonData.CANCEL_CLOSE) {
                    cancelButton = button;
                    break;
                }
                if (!buttonData.isCancelButton()) continue;
                cancelButton = button;
            }
            this.impl_setResultAndClose(cancelButton, false);
        }
        this.dialog.close();
        this.isClosing = false;
    }

    public final void hide() {
        this.close();
    }

    public final void initModality(Modality modality) {
        this.dialog.initModality(modality);
    }

    public final Modality getModality() {
        return this.dialog.getModality();
    }

    public final void initStyle(StageStyle style) {
        this.dialog.initStyle(style);
    }

    public final void initOwner(Window window) {
        this.dialog.initOwner(window);
    }

    public final Window getOwner() {
        return this.dialog.getOwner();
    }

    public void setResizable(boolean resizable) {
        this.dialog.setResizable(resizable);
    }

    public final ObjectProperty<DialogPane> dialogPaneProperty() {
        return this.dialogPane;
    }

    public final DialogPane getDialogPane() {
        return (DialogPane)this.dialogPane.get();
    }

    public final void setDialogPane(DialogPane value) {
        this.dialogPane.set((Object)value);
        value.setDialog(this);
        this.dialog.initStyle(StageStyle.DECORATED);
        this.dialog.setDialogPane(value);
    }

    public final StringProperty contentTextProperty() {
        return this.getDialogPane().contentTextProperty();
    }

    public final void setContentText(String contentText) {
        this.getDialogPane().setContentText(contentText);
    }

    public final String getContentText() {
        return this.getDialogPane().getContentText();
    }

    public void addButonType(ButtonType type) {
        this.getDialogPane().addButonType(type);
    }

    public void setMinSize(double width, double height) {
        this.dialog.setMinSize(width, height);
    }

    public final ObjectProperty<R> resultProperty() {
        return this.resultProperty;
    }

    public final R getResult() {
        return (R)this.resultProperty().get();
    }

    public final void setResult(R value) {
        this.resultProperty().set(value);
    }

    public final ObjectProperty<Callback<ButtonType, R>> resultConverterProperty() {
        return this.resultConverterProperty;
    }

    public final Callback<ButtonType, R> getResultConverter() {
        return (Callback)this.resultConverterProperty().get();
    }

    public final void setResultConverter(Callback<ButtonType, R> value) {
        this.resultConverterProperty().set(value);
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.dialog.showingProperty();
    }

    public final boolean isShowing() {
        return this.showingProperty().get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.dialog.widthProperty();
    }

    public final double getWidth() {
        return this.widthProperty().get();
    }

    public final void setWidth(double width) {
        this.dialog.setWidth(width);
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.dialog.heightProperty();
    }

    public final double getHeight() {
        return this.heightProperty().get();
    }

    public final void setHeight(double height) {
        this.dialog.setHeight(height);
    }

    public final StringProperty titleProperty() {
        return this.dialog.titleProperty();
    }

    public final String getTitle() {
        return (String)this.dialog.titleProperty().get();
    }

    public final void setTitle(String title) {
        this.dialog.titleProperty().set((Object)title);
    }

    public final double getX() {
        return this.dialog.getX();
    }

    public final void setX(double x) {
        this.dialog.setX(x);
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.dialog.xProperty();
    }

    public final double getY() {
        return this.dialog.getY();
    }

    public final void setY(double y) {
        this.dialog.setY(y);
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.dialog.yProperty();
    }

    void impl_setResultAndClose(ButtonType cmd, boolean close) {
        Callback<ButtonType, R> resultConverter = this.getResultConverter();
        R priorResultValue = this.getResult();
        Object newResultValue = null;
        newResultValue = resultConverter == null ? cmd : resultConverter.call((Object)cmd);
        this.setResult(newResultValue);
        if (close && priorResultValue == newResultValue) {
            this.close();
        }
    }

    public void sizeToScene() {
        this.dialog.sizeToScene();
    }
}

