/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.tizen.ecp.utils.FilePath;

public class DynamicLoader
extends URLClassLoader {
    private static ClassLoader youngestLoader;

    private DynamicLoader(URL[] urls) {
        super(urls);
    }

    private DynamicLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public static ClassLoader getClassLoader() {
        return youngestLoader;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }

    static {
        Path parentJarPath = FilePath.getInstance().getParentJARPath();
        Path jarPath = FilePath.getInstance().getPluginJARPath();
        try {
            if (parentJarPath != null) {
                DynamicLoader parentLoader = new DynamicLoader(new URL[]{parentJarPath.toUri().toURL()});
                youngestLoader = new DynamicLoader(new URL[]{jarPath.toUri().toURL()}, (ClassLoader)parentLoader);
            } else {
                youngestLoader = new DynamicLoader(new URL[]{jarPath.toUri().toURL()});
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            assert (false);
            System.exit(-1);
        }
    }
}

