/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.control;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.tizen.ecp.control.ButtonToggleEvent;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;

public class TizenToggleButton
extends HBox {
    private final Label iconLabel;
    private final Label textLabel;
    private final ImageView ON_IMAGE;
    private final ImageView OFF_IMAGE;
    private final int IMAGE_WIDTH = 76;
    private final int BOX_HEIGHT = 24;
    private final String onText;
    private final String offText;
    private boolean isOn;
    private EventHandler<ButtonToggleEvent> onSelected = new EventHandler<ButtonToggleEvent>(){

        public void handle(ButtonToggleEvent arg0) {
        }
    };

    public void setOn(boolean on) {
        this.isOn = on;
        this.changeButton();
    }

    public boolean getOn() {
        return this.isOn;
    }

    public void setOnSelected(EventHandler<ButtonToggleEvent> handler) {
        this.onSelected = handler;
    }

    public TizenToggleButton(String onText, String offText) {
        this.ON_IMAGE = Images.getImageView(ImageKind.TOGGLE_ON);
        this.OFF_IMAGE = Images.getImageView(ImageKind.TOGGLE_OFF);
        this.onText = onText;
        this.offText = offText;
        this.iconLabel = new Label();
        this.textLabel = new Label();
        this.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().addAll((Object[])new Node[]{this.iconLabel, this.textLabel});
        this.setSpacing(5.0);
        this.iconLabel.setPrefSize(76.0, 24.0);
        this.iconLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                TizenToggleButton.this.setOn(!TizenToggleButton.this.isOn);
                TizenToggleButton.this.onSelected.handle((Event)new ButtonToggleEvent(TizenToggleButton.this.isOn));
            }
        });
    }

    private void changeButton() {
        if (this.isOn) {
            this.iconLabel.setGraphic((Node)this.ON_IMAGE);
            this.textLabel.setText(this.onText);
        } else {
            this.iconLabel.setGraphic((Node)this.OFF_IMAGE);
            this.textLabel.setText(this.offText);
        }
    }
}

