/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import com.google.protobuf.GeneratedMessage;
import java.util.Timer;
import java.util.TimerTask;
import org.json.simple.JSONObject;
import org.tizen.cli.AbstractCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.string.CliMessages;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.SocketClient;

public class AbstractEmulatorCLI
extends AbstractCLI
implements ILsn {
    public boolean running = false;
    public String help = "";
    public String messageType = null;
    public int returnValue = 0;
    private Timer runTimer = null;
    public boolean timerExpired = false;

    public void startRunning() {
        if (this.running) {
            OutputUtil.debug("Already running condition.");
            return;
        }
        this.running = true;
        this.runTimer = new Timer();
        this.runTimer.schedule((TimerTask)new runTimerTask(), 7000L);
        while (this.running) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                OutputUtil.printError(CliMessages.getString("AbstractEmulatorCLI.2"), e);
            }
        }
        this.runTimer.cancel();
        this.runTimer = null;
        OutputUtil.debug(CliMessages.getString("AbstractEmulatorCLI.4"));
    }

    public void stopRunning() {
        if (!this.running) {
            OutputUtil.debug("Not running condition.");
            return;
        }
        OutputUtil.debug(CliMessages.getString("AbstractEmulatorCLI.3") + this.runTimer);
        this.running = false;
    }

    public void printHelp() {
        OutputUtil.println(this.help);
    }

    public void OnEventProc(String eventname, JSONObject jsParam) {
    }

    public void OnEventProcPB(String eventname, GeneratedMessage param) {
    }

    public int executeCLI() {
        int ret = 0;
        if (this.messageType != null) {
            EventMgr.getInstance().AddLsn(this.messageType, (ILsn)this);
        }
        if (!SocketClient.getInstance().getGuestStatus()) {
            OutputUtil.printError(CLIConstants.ERR_DESC_EMULATOR_NOT_READY);
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
            return 28;
        }
        ret = this.execute();
        if (this.messageType != null) {
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
        }
        if (this.timerExpired) {
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_RESPONSE);
            return 129;
        }
        if (ret != 0) {
            return ret;
        }
        return this.returnValue;
    }

    @Override
    public int execute() {
        return this.returnValue;
    }

    public void finished() {
    }

    public void OnStatusEventProcPB(GeneratedMessage param) {
    }

    private class runTimerTask
    extends TimerTask {
        private runTimerTask() {
        }

        @Override
        public void run() {
            if (AbstractEmulatorCLI.this.running) {
                AbstractEmulatorCLI.this.running = false;
                AbstractEmulatorCLI.this.timerExpired = true;
            }
        }
    }
}

