/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sock;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageQueue;
import org.tizen.ecp.sock.MsgMgr;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.LogUtil;

public class SocketMessage
implements Runnable {
    private Logger logger = LogUtil.getECPLogger(SocketMessage.class).getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketClient client = SocketClient.getInstance();
        MessageQueue msgQueue = MessageQueue.getInstance();
        try {
            Class<?> lock;
            Class<?> clazz = lock = this.getClass();
            synchronized (clazz) {
                lock.notifyAll();
            }
        }
        catch (IllegalMonitorStateException e) {
            this.logger.log(Level.WARNING, "socket message thread", e);
        }
        MessageQueue messageQueue = msgQueue;
        synchronized (messageQueue) {
            do {
                Ecs.Master msg;
                block13: {
                    try {
                        msgQueue.wait();
                    }
                    catch (InterruptedException e) {
                        if (this.logger == null) break block13;
                        this.logger.log(Level.INFO, e.getMessage());
                    }
                }
                while ((msg = msgQueue.Poll()) != null) {
                    this.processMsg(msg);
                }
            } while (client.isRunning());
        }
    }

    private void processMsg(Ecs.Master msg) {
        MsgMgr.getInstance().ProcBufMsg(msg);
    }
}

