/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tizen.ecp.control.ImageButton;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;

public class TizenRadioButton
extends ImageButton
implements Toggle {
    private Object userData;
    private final Label textLabel;
    private ToggleGroup toggleGroup;

    public TizenRadioButton() {
        this("");
    }

    public TizenRadioButton(String text) {
        super(Images.getImageView(ImageKind.RADIO_NOR), Images.getImageView(ImageKind.RADIO_NOR_HOVER), Images.getImageView(ImageKind.RADIO_NOR_FOCUSED), Images.getImageView(ImageKind.RADIO_SEL), Images.getImageView(ImageKind.RADIO_SEL_HOVER), Images.getImageView(ImageKind.RADIO_SEL_FOCUSED));
        this.textLabel = new Label(text);
        this.add((Node)this.textLabel, 1, 0);
        this.setHgap(4.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.stateProperty.addListener((ChangeListener)new ChangeListener<ImageButton.BUTTON_STATE>(){

            public void changed(ObservableValue<? extends ImageButton.BUTTON_STATE> arg0, ImageButton.BUTTON_STATE arg1, ImageButton.BUTTON_STATE arg2) {
                TizenRadioButton.this.redrawText(arg2);
            }
        });
        this.setFocusTraversable(true);
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                TizenRadioButton.this.drawIcon();
                TizenRadioButton.this.redrawText((ImageButton.BUTTON_STATE)((Object)TizenRadioButton.this.stateProperty.get()));
            }
        });
        this.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                switch (keyCode) {
                    case LEFT: {
                        TizenRadioButton.this.changeFocus(false);
                        break;
                    }
                    case RIGHT: {
                        TizenRadioButton.this.changeFocus(true);
                        break;
                    }
                    case ENTER: 
                    case SPACE: {
                        if (TizenRadioButton.this.isSelected) break;
                        TizenRadioButton.this.setSelected(true);
                        break;
                    }
                }
            }
        });
    }

    private void changeFocus(boolean isNext) {
        int newIndex;
        if (this.toggleGroup == null) {
            return;
        }
        ObservableList list = this.toggleGroup.getToggles();
        int currentIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != this) continue;
            currentIndex = i;
            break;
        }
        int n = newIndex = isNext ? currentIndex + 1 : currentIndex - 1;
        if (newIndex < list.size() && newIndex >= 0) {
            ((TizenRadioButton)((Object)list.get(newIndex))).requestFocus();
        }
    }

    private void redrawText(ImageButton.BUTTON_STATE bState) {
        if (this.isFocused()) {
            this.textLabel.setStyle("-fx-text-fill: #008aee");
            return;
        }
        switch (bState) {
            case NORMAL: 
            case SELECT_NORMAL: {
                this.textLabel.setStyle("-fx-text-fill: #464646");
                break;
            }
            case HOVER: 
            case SELECT_HOVER: 
            case SELECT_PRESS: 
            case PRESS: {
                this.textLabel.setStyle("-fx-text-fill: #000000");
                break;
            }
        }
    }

    @Override
    protected void buttonReleased() {
        this.requestFocus();
        if (this.isSelected) {
            return;
        }
        this.selectToggle();
    }

    private void selectToggle() {
        if (this.toggleGroup == null) {
            return;
        }
        this.toggleGroup.selectToggle((Toggle)this);
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.isSelected == selected) {
            return;
        }
        super.setSelected(selected);
        if (selected) {
            this.selectToggle();
        }
    }

    public void setLabelText(String text) {
        this.textLabel.setText(text);
    }

    public String getLabelText() {
        return this.textLabel.getText();
    }

    public void setToolTip(String text) {
        this.textLabel.setTooltip(new Tooltip(text));
    }

    public ToggleGroup getToggleGroup() {
        return this.toggleGroup;
    }

    public Object getUserData() {
        return this.userData;
    }

    public BooleanProperty selectedProperty() {
        return new SimpleBooleanProperty(this.isSelected);
    }

    public void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroup = toggleGroup;
        toggleGroup.getToggles().add((Object)this);
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public ObjectProperty<ToggleGroup> toggleGroupProperty() {
        return null;
    }
}

