/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.utils;

import com.google.protobuf.CodedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.tizen.cli.CLIManager;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.sock.SocketConstants;

public class AcquireInfoThread
implements Runnable {
    private int port;
    private Thread th;
    boolean isRun = true;
    private Socket sock = null;
    private SocketAddress addr;
    private DataOutputStream output;
    private DataInputStream input;
    private static final String VMINFO = "vminfo";

    @Override
    public void run() {
        OutputUtil.debug("AcquireInfoThread - starts.");
        this.sock = new Socket();
        this.addr = new InetSocketAddress(SocketConstants.DefaultIp, this.port);
        try {
            this.sock.connect(this.addr, 10);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            this.input = new DataInputStream(this.sock.getInputStream());
        }
        catch (IOException e) {
            OutputUtil.printError("IOException", e);
            SocketClient.getInstance().tryClose(new Object[]{this.input, this.output, this.sock});
            return;
        }
        this.th = new Thread(null, new SocketMessageHandler(), "Socket Message Thread");
        this.th.start();
        OutputUtil.debug("AcquireInfoThread - connect.");
        this.sendDeviceReq();
        OutputUtil.debug("AcquireInfoThread - request vmname.");
        while (this.isRun) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                SocketClient.getInstance().tryClose(new Object[]{this.input, this.output, this.sock});
                return;
            }
        }
        if (this.th != null) {
            try {
                this.th.join(10L);
            }
            catch (InterruptedException e) {
                SocketClient.getInstance().tryClose(new Object[]{this.input, this.output, this.sock});
                return;
            }
        }
        SocketClient.getInstance().tryClose(new Object[]{this.input, this.output, this.sock});
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void stopRunning() {
        this.isRun = false;
    }

    public void sendDeviceReq() {
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.DEVICE_REQ);
        Ecs.DeviceReq.Builder deviceBuilder = Ecs.DeviceReq.newBuilder();
        deviceBuilder.setCategory(VMINFO);
        deviceBuilder.setLength(0);
        deviceBuilder.setGroup(0);
        deviceBuilder.setAction(0);
        masterBuilder.setDeviceReq(deviceBuilder);
        Ecs.Master master = masterBuilder.build();
        int serialize_size = master.getSerializedSize();
        try {
            this.output.writeInt(serialize_size);
            master.writeTo((OutputStream)this.output);
            this.output.flush();
        }
        catch (IOException e) {
            OutputUtil.debug("sendDeviceReq - IOException");
            return;
        }
    }

    public void OnEventProcPB(Ecs.Master msg) {
        String[] info = null;
        Ecs.DeviceAns param = msg.getDeviceAns();
        String cat = param.getCategory();
        if (cat == null || !VMINFO.equals(cat)) {
            OutputUtil.debug("AcquireInfoThread - not vminfo: " + cat);
            return;
        }
        OutputUtil.debug("AcquireInfoThread - OnEventProcPB.");
        String data = param.getData().toStringUtf8();
        OutputUtil.debug("AcquireInfoThread - len + data: " + data.length() + ", " + data);
        info = data.split(" ");
        OutputUtil.debug("AcquireInfoThread - vmname: " + info[0] + ", profile: " + info[1] + ", version: " + info[2]);
        CLIManager.getInstance().addInfo(info[0], info[1], info[2], this.port - 3);
        this.stopRunning();
        OutputUtil.debug("AcquireInfoThread - received.");
    }

    class SocketMessageHandler
    implements Runnable {
        SocketMessageHandler() {
        }

        @Override
        public void run() {
            int size = 0;
            try {
                while ((size = AcquireInfoThread.this.input.readInt()) > 0 && AcquireInfoThread.this.isRun) {
                    int available = AcquireInfoThread.this.input.available();
                    if (size > available) continue;
                    byte[] buff = new byte[size];
                    int read = AcquireInfoThread.this.input.read(buff);
                    if (read > size) {
                        return;
                    }
                    CodedInputStream codedIn = CodedInputStream.newInstance((byte[])buff);
                    if (codedIn == null) continue;
                    Ecs.Master msg = Ecs.Master.parseFrom((CodedInputStream)codedIn);
                    AcquireInfoThread.this.OnEventProcPB(msg);
                }
            }
            catch (EOFException e) {
                OutputUtil.debug("SocketMessageHandler - EOFException");
                AcquireInfoThread.this.stopRunning();
            }
            catch (IOException e) {
                AcquireInfoThread.this.stopRunning();
            }
        }
    }
}

