/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.cli.CLIManager;
import org.tizen.cli.ConnectionManager;
import org.tizen.cli.utils.ArgsUtil;
import org.tizen.cli.utils.EmulatorDevice;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.DynamicLoader;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;
import org.tizen.ecp.utils.FilePath;

public class TizenEmulatorAutoComplete {
    private static void initializeECPInfo(String name, int port, String platformVersion, String profile) throws IOException, JAXBException {
        VMInfo.getInstance().initialize(name, port, platformVersion, profile);
        FilePath.initialize((String)name);
        Path ecpInfoPath = FilePath.getInstance().getPluginXMLPath();
        ECPInfo.getInstance().initialize(ecpInfoPath);
    }

    private static String appendComplete(String des, String src) {
        return des + (src + " ");
    }

    private static String getDeviceList(boolean help) {
        String devices = "";
        List deviceList = ECPInfo.getInstance().getDevice();
        String[] qmpCmds = new String[]{"hmp", "qmp", "keycode", "hds"};
        if (deviceList != null) {
            String prof = ECPInfo.getInstance().getParentProfile();
            for (DeviceType d : deviceList) {
                String cmd;
                if (d.getCLICommand() == null && prof != null && (d = ECPInfo.getInstance().getExtDevice(d.getName())) == null || (cmd = d.getCLICommand()) == null || cmd.isEmpty()) continue;
                devices = TizenEmulatorAutoComplete.appendComplete(devices, cmd + " ");
            }
            for (String elsecmd : qmpCmds) {
                devices = TizenEmulatorAutoComplete.appendComplete(devices, elsecmd + " ");
            }
        }
        if (help) {
            devices = TizenEmulatorAutoComplete.appendComplete(devices, "help");
        }
        return devices;
    }

    private static String getCommandList(String device) {
        Class<?> dClass = null;
        String command = "";
        DeviceType matchDevice = CLIManager.getInstance().findDevice(device);
        if (matchDevice == null) {
            return command;
        }
        try {
            dClass = DynamicLoader.getClassLoader().loadClass(matchDevice.getCLIImpl());
        }
        catch (ClassNotFoundException e) {
            OutputUtil.printError("CLIManager - ClassNotFound: " + matchDevice.getCLIImpl());
        }
        if (dClass == null) {
            return command;
        }
        for (Field field : dClass.getDeclaredFields()) {
            SubCommands cmds = field.getAnnotation(SubCommands.class);
            if (cmds == null) continue;
            for (SubCommand cmd : cmds.value()) {
                command = TizenEmulatorAutoComplete.appendComplete(command, cmd.name() + " ");
            }
        }
        return command;
    }

    private static String getArgsList(String device, String command) {
        String argsList = "";
        Class<?> dClass = null;
        Class<?> matchClass = null;
        DeviceType matchDevice = CLIManager.getInstance().findDevice(device);
        if (matchDevice == null || command == null || command.isEmpty()) {
            return argsList;
        }
        try {
            dClass = DynamicLoader.getClassLoader().loadClass(matchDevice.getCLIImpl());
        }
        catch (ClassNotFoundException e) {
            OutputUtil.printError("CLIManager - ClassNotFound: " + matchDevice.getCLIImpl());
        }
        if (dClass == null) {
            return argsList;
        }
        for (Field f : dClass.getDeclaredFields()) {
            SubCommands cmds = f.getAnnotation(SubCommands.class);
            if (cmds == null) continue;
            for (SubCommand cmd : cmds.value()) {
                if (!cmd.name().equals(command)) continue;
                try {
                    matchClass = DynamicLoader.getClassLoader().loadClass(cmd.impl().getCanonicalName());
                }
                catch (ClassNotFoundException e) {
                    OutputUtil.printError("CLIManager - ClassNotFound: " + matchDevice.getCLIImpl());
                    continue;
                }
                for (Field field : matchClass.getDeclaredFields()) {
                    String[] metaArgs;
                    Argument argument = field.getAnnotation(Argument.class);
                    if (argument == null) continue;
                    for (String value : metaArgs = argument.metaVar().split(" ")) {
                        if (value == null || value.isEmpty()) continue;
                        argsList = TizenEmulatorAutoComplete.appendComplete(argsList, value + " ");
                    }
                }
            }
        }
        return argsList;
    }

    public static void main(String[] args) {
        String complete = "";
        String[] argument = args;
        ConnectionManager.getInstance().checkServer();
        CLIManager.getInstance().checkTarget(argument);
        EmulatorDevice device = CLIManager.getInstance().getSelectedDevice();
        if (device == null && args.length == 1) {
            System.out.println("help");
            return;
        }
        if (device == null) {
            return;
        }
        try {
            TizenEmulatorAutoComplete.initializeECPInfo(device.getVmName(), device.getPort(), device.getVersion(), device.getProfile());
        }
        catch (IOException e) {
            return;
        }
        catch (JAXBException e) {
            return;
        }
        if (ArgsUtil.isTargetOptionSpecified(argument) && (argument = ArgsUtil.removeTargetSpecified(argument)) == null) {
            return;
        }
        if (argument.length == 1) {
            complete = TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getDeviceList(true));
        } else if (argument.length == 2) {
            complete = argument[1].toLowerCase().equals("help") ? TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getDeviceList(false)) : TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getCommandList(argument[1]));
        } else if (argument.length == 3) {
            complete = TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getArgsList(argument[1], argument[2]));
        }
        if (complete != null && !complete.isEmpty()) {
            System.out.println(complete.trim());
        }
        System.exit(0);
    }
}

