/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor;

import org.json.simple.JSONObject;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.JsonUtil;

public class TizenEmulatorHMP
extends AbstractEmulatorCLI {
    @Argument(index=0, required=true)
    public String command;

    public TizenEmulatorHMP() {
        this.messageType = "hmp";
    }

    @Override
    public int execute() {
        int ret = 0;
        if (this.messageType != null) {
            EventMgr.getInstance().AddLsn(this.messageType, (ILsn)this);
        }
        ret = this.executeHMP();
        if (this.messageType != null) {
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
        }
        if (this.timerExpired) {
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_RESPONSE);
            return 129;
        }
        if (ret != 0) {
            return ret;
        }
        return this.returnValue;
    }

    private int executeHMP() {
        String msg = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)this.command), (String)"hmp");
        MessageSender.getInstance().sendMonitorReq(msg);
        this.startRunning();
        return 0;
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
        OutputUtil.println((String)jsParam.get((Object)"return"));
        this.stopRunning();
    }
}

