/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.NullCompletor;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.CLIManager;
import org.tizen.cli.ConnectionManager;
import org.tizen.cli.commands.EmulatorCommandsHandler;
import org.tizen.cli.session.ArgCompletor;
import org.tizen.cli.session.CommandCompletor;
import org.tizen.cli.session.DeviceCompletor;
import org.tizen.cli.string.CliMessages;
import org.tizen.cli.utils.ArgsUtil;
import org.tizen.cli.utils.EmulatorDevice;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.sock.SocketMessage;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.LogUtil;

public class TizenEmulatorCli
implements IConnection {
    private static Logger logger = null;
    private static String help = null;
    private ConsoleReader reader = null;
    @Argument(index=0, required=true, handler=EmulatorCommandsHandler.class)
    private AbstractEmulatorCLI tizenCLI;

    public static void exit(int status) {
        System.exit(status);
    }

    public static void main(String[] args) {
        int ret = 0;
        TizenEmulatorCli emulatorCli = new TizenEmulatorCli();
        ret = emulatorCli.run(args);
        TizenEmulatorCli.exit(-ret);
    }

    private void finished() {
        Collection<Object> objs = CLIManager.getInstance().getClassInstances();
        for (Object obj : objs) {
            if (!(obj instanceof AbstractEmulatorCLI)) continue;
            ((AbstractEmulatorCLI)obj).finished();
        }
    }

    private int sessionMode(EmulatorDevice device) throws IOException {
        String line;
        int ret = 0;
        OutputUtil.println("Start Emulator control panel CLI.");
        CLIManager.getInstance().setSessionMode(true);
        help = this.makeHelpString();
        if (help == null) {
            logger.severe("Failed to create help message: check xml.");
            return 22;
        }
        if (!SocketClient.getInstance().connect(VMInfo.getInstance().getSvrPort())) {
            OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_EMUL_CONNECTION);
            logger.severe("Failed to connect the emulator : " + device.getVmName());
            return 24;
        }
        SocketClient.getInstance().registerDisconnectListener((IConnection)this);
        SocketMessage sMessage = new SocketMessage();
        new Thread(null, (Runnable)sMessage, "Socket Message Thread").start();
        try {
            sMessage.latch.await();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Socket Message waiting is interrupted.", e);
        }
        MessageSender.getInstance().sendInjectorReq("guest", 15, 0);
        this.reader = new ConsoleReader();
        this.reader.setBellEnabled(false);
        LinkedList<Object> completors = new LinkedList<Object>();
        DeviceCompletor dCompletor = new DeviceCompletor();
        completors.add(dCompletor);
        CommandCompletor cCompletor = new CommandCompletor(dCompletor);
        completors.add(cCompletor);
        completors.add(new ArgCompletor(cCompletor));
        completors.add(new NullCompletor());
        this.reader.addCompletor((Completor)new ArgumentCompletor(completors));
        while ((line = this.reader.readLine(">> ")) != null) {
            String[] args = line.split(" ");
            if (args[0] != null && args[0].toLowerCase().equals("exit")) {
                this.finished();
                break;
            }
            ret = this.shellMode(args = ArgsUtil.checkArgs(args));
            if (ret < 0) {
                logger.warning("session mode launch failed with " + ret);
            }
            this.tizenCLI = null;
        }
        return 0;
    }

    private String makeHelpString() {
        List devices = ECPInfo.getInstance().getDevice();
        if (devices == null) {
            return null;
        }
        String helpString = "";
        String HELP_USAGE = CLIConstants.STRING_USAGE + (CLIManager.getInstance().getSessionMode() ? "" : "ecp-cli ") + (CLIManager.getInstance().getSessionMode() ? "" : CLIConstants.STRING_TARGET + " ") + CLIConstants.STRING_PARAMS + StringResources.NEW_LINE + StringResources.NEW_LINE;
        String HELP_DEVICE_INFO = CliMessages.getString("TizenEmulatorCli.7") + (CLIManager.getInstance().getSessionMode() ? "" : CliMessages.getString("TizenEmulatorCli.9")) + CliMessages.getString("TizenEmulatorCli.10");
        helpString = OutputUtil.appendComplete(helpString, HELP_USAGE);
        helpString = OutputUtil.appendComplete(helpString, CLIConstants.HELP_DEVICE_LIST);
        String prof = ECPInfo.getInstance().getParentProfile();
        for (DeviceType dev : devices) {
            if (dev.getCardImpl() == null && dev.getPopupImpl() == null && prof != null && (dev = ECPInfo.getInstance().getExtDevice(dev.getName())) == null) continue;
            String cmd = dev.getCLICommand();
            String desc = dev.getCLIDescription();
            if (cmd == null || cmd.isEmpty() || desc == null || desc.isEmpty()) continue;
            helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList(cmd, desc));
        }
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("keycode", CLIConstants.DESC_KEYCODE));
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("hmp", CLIConstants.DESC_HMP));
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("qmp", CLIConstants.DESC_QMP));
        helpString = OutputUtil.appendComplete(helpString, StringResources.NEW_LINE);
        helpString = OutputUtil.appendComplete(helpString, HELP_DEVICE_INFO);
        return helpString;
    }

    private boolean connected() {
        if (CLIManager.getInstance().getSessionMode()) {
            return true;
        }
        EmulatorDevice device = CLIManager.getInstance().getSelectedDevice();
        if (device == null) {
            return false;
        }
        if (!SocketClient.getInstance().connect(VMInfo.getInstance().getSvrPort())) {
            return false;
        }
        SocketClient.getInstance().registerDisconnectListener((IConnection)this);
        SocketMessage sMessage = new SocketMessage();
        new Thread(null, (Runnable)sMessage, "Socket Message Thread").start();
        try {
            sMessage.latch.await();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Socket Message waiting is interrupted.", e);
        }
        MessageSender.getInstance().sendInjectorReq("guest", 15, 0);
        return true;
    }

    private void disconnect() {
        if (CLIManager.getInstance().getSessionMode()) {
            return;
        }
        SocketClient.getInstance().disconnect();
    }

    private int shellMode(String[] args) {
        logger.info(Arrays.toString(args));
        CmdLineParser cmdParser = null;
        if (args == null || args.length <= 0 || args[0] == null || args[0].isEmpty()) {
            logger.severe("shellMode args[0] is null.");
            return 1;
        }
        if (args[0].toLowerCase().trim().equals("qmp") || args[0].toLowerCase().trim().equals("hmp")) {
            args = ArgsUtil.getRemainArgs(args);
        }
        cmdParser = new CmdLineParser((Object)this);
        cmdParser.stopOptionParsing();
        try {
            cmdParser.parseArgument(args);
            cmdParser.setUsageWidth(Integer.MAX_VALUE);
        }
        catch (CmdLineException e) {
            logger.log(Level.WARNING, "cmd paring error", e);
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_PROPER_CMDS);
            OutputUtil.println(help);
            return 25;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "cmd paring exception", e);
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_PROPER_CMDS);
            OutputUtil.println(help);
            return 25;
        }
        if (null != this.tizenCLI) {
            this.tizenCLI.help = help;
            if (!this.connected()) {
                OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_EMUL_CONNECTION);
                return 24;
            }
            int ret = this.tizenCLI.execute();
            this.disconnect();
            return ret;
        }
        return 0;
    }

    private void logInit() throws IOException {
        LogUtil.init((LogUtil.ECPLogLevel)LogUtil.ECPLogLevel.DEBUG, (boolean)true);
        logger = LogUtil.getECPLogger(TizenEmulatorCli.class).getLogger();
    }

    private void initializeECPInfo(String name, int port, String profile) throws IOException, JAXBException {
        Path ecpInfoPath = FilePath.getInstance().getPluginXMLPath();
        logger.info("xml path: " + ecpInfoPath);
        ECPInfo.getInstance().initialize(ecpInfoPath);
    }

    private void printProfile(String version) {
        Path platformPath = FilePath.getInstance().getPlatformPath();
        if (platformPath == null) {
            return;
        }
        OutputUtil.println("Available profiles are: ");
        ArrayList<String> profileList = new ArrayList<String>();
        Path path = platformPath.resolve(version);
        try (DirectoryStream<Path> versionDir = Files.newDirectoryStream(path);){
            for (Path subPath : versionDir) {
                Path fileName = subPath.getFileName();
                if (fileName == null) continue;
                String profileName = fileName.toString();
                String plugin = "ecp-plugin-" + profileName + version.substring(version.indexOf("-")) + ".xml";
                Path pluginPath = path.resolve(profileName).resolve("emulator-resources").resolve("plugins").resolve(plugin);
                if (!Files.exists(pluginPath, new LinkOption[0])) continue;
                profileList.add(profileName);
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            e.printStackTrace();
        }
        if (!profileList.isEmpty()) {
            for (String profile : profileList) {
                OutputUtil.printTabln(profile);
            }
        }
    }

    private void printVersionProfile() {
        Path platformPath = FilePath.getInstance().getPlatformPath();
        if (platformPath == null) {
            return;
        }
        OutputUtil.println("Available platforms are: ");
        ArrayList<String> profileList = new ArrayList<String>();
        try (DirectoryStream<Path> platformDir = Files.newDirectoryStream(platformPath);){
            for (Path path : platformDir) {
                Path fileName;
                if (!Files.isDirectory(path, new LinkOption[0]) || (fileName = path.getFileName()) == null) continue;
                String version = fileName.toString();
                DirectoryStream<Path> versionDir = Files.newDirectoryStream(path);
                for (Path subPath : versionDir) {
                    fileName = subPath.getFileName();
                    if (fileName == null) continue;
                    String profileName = fileName.toString();
                    String plugin = "ecp-plugin-" + profileName + version.substring(version.indexOf("-")) + ".xml";
                    Path pluginPath = path.resolve(profileName).resolve("emulator-resources").resolve("plugins").resolve(plugin);
                    if (!Files.exists(pluginPath, new LinkOption[0])) continue;
                    profileList.add(profileName);
                }
                if (!profileList.isEmpty()) {
                    OutputUtil.printTabln(version);
                    for (String profile : profileList) {
                        OutputUtil.printTabln("\t" + profile);
                    }
                }
                profileList.clear();
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            e.printStackTrace();
        }
    }

    private void printHelpWithoutVM(String version, String profile) {
        Path platformPath = FilePath.getInstance().getPlatformPath();
        if (platformPath == null) {
            return;
        }
        String plugin = "ecp-plugin-" + profile + version.substring(version.indexOf("-")) + ".xml";
        Path path = platformPath.resolve(version).resolve(profile).resolve("emulator-resources").resolve("plugins").resolve(plugin);
        if (!Files.exists(path, new LinkOption[0])) {
            OutputUtil.debug("No such file: " + path.toString());
            OutputUtil.printError(CliMessages.getString("TizenEmulatorCli.12") + version + ", " + profile);
            OutputUtil.println(CliMessages.getString("TizenEmulatorCli.11"));
            this.printVersionProfile();
            return;
        }
        try {
            ECPInfo.getInstance().initialize(path);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        OutputUtil.println(this.makeHelpString());
    }

    private int run(String[] args) {
        int ret = 0;
        ConnectionManager.getInstance().checkServer();
        OutputUtil.debug("check server");
        ret = CLIManager.getInstance().checkTarget(args);
        if (ret == 19) {
            OutputUtil.printError(CLIConstants.ERR_DESC_MULTI_TARGET);
            OutputUtil.println(CliMessages.getString("CLIConstants.29"));
            for (EmulatorDevice dev : CLIManager.getInstance().getDevices()) {
                OutputUtil.printVMInfo(dev.getVmName(), dev.getTarget(), dev.getProfile());
            }
            return ret;
        }
        if (ret == 18) {
            String targetSpecified = ArgsUtil.getTargetValueSpecified(args);
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_TARGET_EXIST + " " + "(" + targetSpecified + ")");
            OutputUtil.println(CliMessages.getString("CLIConstants.29"));
            for (EmulatorDevice dev : CLIManager.getInstance().getDevices()) {
                OutputUtil.printVMInfo(dev.getVmName(), dev.getTarget(), dev.getProfile());
            }
            return ret;
        }
        if (ret == 17) {
            boolean isProfile = ArgsUtil.isOptionSpecified(args, "--profile", "-p");
            boolean isVersion = ArgsUtil.isOptionSpecified(args, "--version", "-v");
            if (isVersion && isProfile) {
                String version = ArgsUtil.getVersionValueSpecified(args);
                String profile = ArgsUtil.getProfileValueSpecified(args);
                this.printHelpWithoutVM(version, profile);
                return ret;
            }
            if (isVersion) {
                OutputUtil.printError(CliMessages.getString("TizenEmulatorCli.14"));
                OutputUtil.println(CliMessages.getString("TizenEmulatorCli.11"));
                String version = ArgsUtil.getVersionValueSpecified(args);
                this.printProfile(version);
            } else {
                OutputUtil.printError(CliMessages.getString("TizenEmulatorCli.13"));
                OutputUtil.println(CliMessages.getString("TizenEmulatorCli.11"));
                this.printVersionProfile();
            }
            return ret;
        }
        EmulatorDevice device = CLIManager.getInstance().getSelectedDevice();
        if (device == null) {
            OutputUtil.printError(CLIConstants.ERR_DESC_UNEXPECTED);
            return 1;
        }
        String vmname = device.getVmName();
        if (vmname == null || vmname.isEmpty()) {
            OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_EMUL_CONNECTION);
            return 1;
        }
        VMInfo.getInstance().initialize(vmname, device.getPort(), device.getVersion(), device.getProfile());
        FilePath.initialize((String)vmname);
        int port = device.getPort();
        OutputUtil.debug(CliMessages.getString("TizenEmulatorCli.22") + vmname + CliMessages.getString("TizenEmulatorCli.23") + port);
        if (ArgsUtil.isTargetOptionSpecified(args) && !ArgsUtil.isTargetOptionSpecified(args)) {
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_TARGET_SPECIFIED);
            return 20;
        }
        if (ArgsUtil.isTargetOptionSpecified(args)) {
            args = ArgsUtil.removeTargetSpecified(args);
        }
        try {
            this.logInit();
        }
        catch (IOException e) {
            OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_CREATION_LOG, e);
            return 21;
        }
        logger.info("!!! Start Emulator Control Panel CLI!!!");
        logger.info("device name is " + vmname + " and port is " + port);
        try {
            this.initializeECPInfo(vmname, port, device.getProfile());
        }
        catch (IOException e) {
            logger.severe("IOException: " + e.getMessage());
            OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_EMUL_INFO, e);
            return 22;
        }
        catch (JAXBException e) {
            logger.severe("JAXBException: " + e.getMessage());
            OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_EMUL_INFO, (Exception)((Object)e));
            return 22;
        }
        CLIManager.getInstance().loadClass();
        try {
            if (args == null || args.length == 0) {
                ret = this.sessionMode(device);
            } else {
                help = this.makeHelpString();
                if (help == null) {
                    logger.severe("Failed to create help message: check xml.");
                    return 22;
                }
                ret = this.shellMode(args);
            }
        }
        catch (IOException e) {
            OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_MODE_SESSION, e);
            return 23;
        }
        return ret;
    }

    public void disconnected() {
        if (CLIManager.getInstance().getSessionMode()) {
            OutputUtil.print("\n");
            OutputUtil.printError(CLIConstants.ERR_DESC_LOST_CONNECTION);
            TizenEmulatorCli.exit(-27);
        }
    }

    public void guestOn() {
    }

    public void guestOff() {
    }

    public void guestOffMessage() {
    }
}

