/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.cli.string.CliMessages;
import org.tizen.cli.utils.AcquireInfoThread;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.sock.SocketConstants;
import org.tizen.ecp.utils.LogUtil;

public class ConnectionManager {
    private static ConnectionManager instance = new ConnectionManager();
    private static Logger logger = LogUtil.getECPLogger(ConnectionManager.class).getLogger();

    public static ConnectionManager getInstance() {
        return instance;
    }

    private void tryClose(Object ... closeables) {
        if (null == closeables) {
            return;
        }
        for (Object obj : closeables) {
            if (null == obj) continue;
            try {
                if (obj instanceof Closeable) {
                    ((Closeable)obj).close();
                    continue;
                }
                if (!(obj instanceof Socket)) continue;
                ((Socket)obj).close();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] getPossiblePort() {
        int[] ports = new int[10];
        int index = 0;
        Socket sock = null;
        for (int port = 26103; port < 26200; ++index, port += 10) {
            try {
                sock = new Socket();
                InetSocketAddress addr = new InetSocketAddress(SocketConstants.DefaultIp, port);
                sock.connect(addr, 100);
                ports[index] = port;
                if (sock == null) continue;
            }
            catch (UnknownHostException e) {
                ports[index] = 0;
                if (sock == null) continue;
                {
                    catch (Throwable throwable) {
                        if (sock != null) {
                            this.tryClose(sock);
                            sock = null;
                        }
                        throw throwable;
                    }
                }
                this.tryClose(sock);
                sock = null;
                continue;
                catch (IOException e2) {
                    ports[index] = 0;
                    if (sock == null) continue;
                    this.tryClose(sock);
                    sock = null;
                    continue;
                }
            }
            this.tryClose(sock);
            sock = null;
            continue;
        }
        int i = 0;
        while (i < 10) {
            OutputUtil.debug(CliMessages.getString("ConnectionManager.0") + i + CliMessages.getString("ConnectionManager.1") + ports[i]);
            ++i;
        }
        return ports;
    }

    public void checkServer() {
        int[] ports = this.getPossiblePort();
        Thread[] threads = new Thread[10];
        if (ports == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int port = ports[i];
            if (port == 0) {
                threads[i] = null;
                continue;
            }
            OutputUtil.debug("request vmname to port : " + port);
            AcquireInfoThread run = new AcquireInfoThread();
            run.setPort(port);
            threads[i] = new Thread(null, run, "AcquireNameThread" + i);
            threads[i].start();
            OutputUtil.debug("request vmname thread starts.");
            try {
                threads[i].join(5000L);
                if (threads[i].isAlive()) {
                    logger.warning("Check server still alive. timeout = 5000");
                    run.stopRunning();
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "checking server is interrupted.", e);
            }
            OutputUtil.debug("request vmname thread ends.");
        }
    }
}

