/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views.popup;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.views.popup.ECPPopupModel;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class ECPPopupAction
implements Initializable {
    @FXML
    AnchorPane rootPane;
    @FXML
    Label closeButton;
    @FXML
    Label titleLabel;
    @FXML
    AnchorPane popupPane;
    private final ECPPopupModel model;
    final Delta dragDelta = new Delta();

    public ECPPopupAction(ECPPopupModel model) {
        this.model = model;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Pane pane;
        this.closeButton.setGraphic((Node)Images.getImageView(ImageKind.CLOSE_POPUP));
        this.titleLabel.textProperty().bind((ObservableValue)this.model.getTitle());
        if (this.model.getWidth() != 0.0 && this.model.getHeight() != 0.0) {
            this.rootPane.setPrefWidth(this.model.getWidth());
            this.rootPane.setPrefHeight(this.model.getHeight());
        }
        if ((pane = this.model.getPopupPane()) != null) {
            this.popupPane.getChildren().add((Object)pane);
            AnchorPane.setTopAnchor((Node)pane, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)pane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)pane, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)pane, (Double)0.0);
        }
        this.titleLabel.setFocusTraversable(true);
        this.addESCListener((Node)this.titleLabel);
        this.addESCListener((Node)this.popupPane);
    }

    private void addESCListener(Node node) {
        node.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    ECPPopupAction.this.closePopup();
                }
            }
        });
    }

    @FXML
    public void closeMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_CLICKED) {
            this.closePopup();
        }
    }

    private void closePopup() {
        this.model.getStage().close();
        ECPPopupPane ecpPane = this.model.getEcpPane();
        if (ecpPane != null) {
            ecpPane.onClose();
        }
    }

    @FXML
    public void popupMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.dragDelta.x = this.model.getStage().getX() - event.getScreenX();
            this.dragDelta.y = this.model.getStage().getY() - event.getScreenY();
        } else if (event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
            this.model.getStage().setX(event.getScreenX() + this.dragDelta.x);
            this.model.getStage().setY(event.getScreenY() + this.dragDelta.y);
        }
    }

    static class Delta {
        double x;
        double y;

        Delta() {
        }
    }
}

