/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.dialog.shortcut;

import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import org.tizen.ecp.dialog.shortcut.ListCellData;

class CardListCell
extends ListCell<ListCellData> {
    private static final String TEXT_FILL_NORMAL = "-fx-text-fill: #585858; -fx-font-size: 100%; -fx-font-weight: normal;";
    private static final String TEXT_FILL_SELECT = "-fx-text-fill: #585858; -fx-font-size: 100%; -fx-font-weight: bold;";
    Label label;
    BooleanProperty isSelect;
    private final ChangeListener<Boolean> listener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isSelected) {
            if (isSelected.booleanValue()) {
                CardListCell.this.label.setStyle(CardListCell.TEXT_FILL_SELECT);
            } else {
                CardListCell.this.label.setStyle(CardListCell.TEXT_FILL_NORMAL);
            }
        }
    };

    CardListCell() {
    }

    protected void updateItem(ListCellData data, boolean isblank) {
        super.updateItem((Object)data, isblank);
        if (isblank) {
            if (this.isSelect != null) {
                this.isSelect.removeListener(this.listener);
            }
            return;
        }
        this.label = new Label(data.getTitle());
        this.isSelect = data.getIsSelect();
        this.isSelect.addListener(this.listener);
        if (this.isSelect.get()) {
            this.label.setStyle(TEXT_FILL_SELECT);
        } else {
            this.label.setStyle(TEXT_FILL_NORMAL);
        }
        this.setPadding(new Insets(8.0));
        this.setGraphic((Node)this.label);
    }

    static Callback<ListView<ListCellData>, ListCell<ListCellData>> extractor() {
        return new Callback<ListView<ListCellData>, ListCell<ListCellData>>(){

            public ListCell<ListCellData> call(ListView<ListCellData> arg0) {
                return new CardListCell();
            }
        };
    }
}

