/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.resources;

import java.util.function.Supplier;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.tizen.ecp.resources.FontSupplier;
import org.tizen.ecp.resources.ResourceKind;
import org.tizen.ecp.utils.OSUtil;

public class FontKind
implements ResourceKind {
    public static FontKind FONT_38_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 38.0), () -> Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)37.0), new FontSupplier("BreezeSans-Bold", 38.0));
    public static FontKind FONT_32_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 32.0), () -> Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)31.0), new FontSupplier("BreezeSans-Bold", 32.0));
    public static FontKind FONT_16 = new FontKind(new FontSupplier("BreezeSans", 16.0), () -> Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)15.0), new FontSupplier("BreezeSans", 16.0));
    public static FontKind FONT_21 = new FontKind(new FontSupplier("BreezeSans", 21.0), () -> Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)20.0), new FontSupplier("BreezeSans", 21.0));
    private final Supplier<Font> linuxSupplier;
    private final Supplier<Font> winSupplier;
    private final Supplier<Font> macSupplier;

    public FontKind(Supplier<Font> supplier) {
        this.linuxSupplier = supplier;
        this.winSupplier = supplier;
        this.macSupplier = supplier;
    }

    public FontKind(Supplier<Font> linuxSupplier, Supplier<Font> winSupplier, Supplier<Font> macSupplier) {
        this.linuxSupplier = linuxSupplier;
        this.winSupplier = winSupplier;
        this.macSupplier = macSupplier;
    }

    public Supplier<Font> getSupplier() {
        if (OSUtil.isMacPlatform()) {
            return this.macSupplier;
        }
        if (OSUtil.isWindowsPlatform()) {
            return this.winSupplier;
        }
        return this.linuxSupplier;
    }
}

