/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor;

import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.CLIManager;
import org.tizen.cli.string.CliMessages;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.utils.LogUtil;

public class TizenEmulatorHelp
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(TizenEmulatorHelp.class).getLogger();
    @Argument(index=0)
    String target;

    @Override
    public int execute() {
        DeviceType device = null;
        if (this.target == null) {
            OutputUtil.println(this.help);
        } else {
            device = CLIManager.getInstance().findDevice(this.target);
            if (device != null) {
                try {
                    Class<?> dp = CLIManager.getInstance().getClass(device.getCLIImpl());
                    if (dp == null) {
                        OutputUtil.printError(CLIConstants.ERR_DESC_FAIL_CLASS_LOADER, this.target);
                        this.target = null;
                        return 22;
                    }
                    AbstractEmulatorCLI handler = (AbstractEmulatorCLI)CLIManager.getInstance().instantiate(dp);
                    if (handler == null) {
                        OutputUtil.printError(CLIConstants.ERR_DESC_NO_SUPPORTED_CLASS);
                        this.target = null;
                        return 22;
                    }
                    handler.printHelp();
                }
                catch (IllegalAccessException e) {
                    OutputUtil.printError(CLIConstants.ERR_DESC_PARSING_XML, e);
                    logger.severe("IllegalAccessException: " + e.getMessage());
                }
                catch (InstantiationException e) {
                    OutputUtil.printError(CLIConstants.ERR_DESC_PARSING_XML, e);
                    logger.severe("InstantiationException: " + e.getMessage());
                }
                catch (ClassCastException e) {
                    OutputUtil.printError(CLIConstants.ERR_DESC_PARSING_XML, e);
                    logger.severe("ClassCastException: " + e.getMessage());
                }
            } else if ("hmp".equals(this.target)) {
                OutputUtil.printDeviceUsage("hmp");
                OutputUtil.println("\t" + CLIConstants.STRING_HMP_SEE_MAN);
            } else if ("qmp".equals(this.target)) {
                OutputUtil.printDeviceUsage("qmp");
                OutputUtil.println("\t" + CLIConstants.STRING_QMP_SEE_MAN);
            } else if ("keycode".equals(this.target)) {
                OutputUtil.println(OutputUtil.getDeviceUsage(CliMessages.getString("TizenEmulatorHelp.3")) + CliMessages.getString("TizenEmulatorHelp.4") + CLIConstants.STRING_TARGET + StringResources.NEW_LINE + StringResources.NEW_LINE + CLIConstants.HELP_COMMAND_ARGS + OutputUtil.getFormatList(CliMessages.getString("TizenEmulatorHelp.5")) + OutputUtil.getFormatList(CliMessages.getString("TizenEmulatorHelp.6")) + OutputUtil.getFormatList(CliMessages.getString("TizenEmulatorHelp.7")));
            } else {
                OutputUtil.printError(CLIConstants.ERR_DESC_NO_PROPER_CMDS);
                this.target = null;
                return 25;
            }
        }
        this.target = null;
        return 0;
    }
}

