/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.utils.LogUtil;

public class ECPParseArgs {
    private static Logger logger = LogUtil.getECPLogger(ECPParseArgs.class).getLogger();
    private static final int MIN_BASE_PORT = 26100;
    private static final int MAX_BASE_PORT = 26200;

    public static Map<String, String> parseArgs(String[] args) {
        int basePort;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            logger.info("arg[" + i + "] " + arg);
            String[] split = arg.split("=");
            if (1 < split.length) {
                String argKey = split[0].trim();
                String argValue = split[1].trim();
                map.put(argKey, argValue);
                continue;
            }
            logger.info("single argv:" + arg);
        }
        logger.info("================= argsMap =====================");
        logger.info(((Object)map).toString());
        logger.info("===============================================");
        if (!map.containsKey("vm_name")) {
            logger.severe("vm_name argument is wrong");
            return null;
        }
        String name = (String)map.get("vm_name");
        if (!map.containsKey("base_port")) {
            logger.severe("base port argument is wrong");
            return null;
        }
        try {
            basePort = Integer.parseInt((String)map.get("base_port"));
            if (!ECPParseArgs.isSupportPort(basePort)) {
                logger.severe("Failed to launch Emulator Control Panel.\nPlease report this bug.\n\tInvalid port value: " + basePort);
            }
        }
        catch (NumberFormatException e) {
            logger.log(Level.SEVERE, "Failed to launch Emulator Control Panel.\nPlease report this bug.\n\tInvalid port value", e);
            return null;
        }
        String platformVersion = (String)map.get("platform_version");
        String profile = (String)map.get("profile");
        VMInfo.getInstance().initialize(name, basePort, platformVersion, profile);
        return map;
    }

    private static boolean isSupportPort(int port) {
        return port >= 26100 && port < 26200 && port % 10 == 0;
    }

    public static interface ArgsConstants {
        public static final String BASEPORT = "base_port";
        public static final String VMNAME = "vm_name";
        public static final String PLATFORM_VERSION = "platform_version";
        public static final String VMPROFILE = "profile";
    }
}

