/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.JsonUtil;

public class TizenEmulatorQMP
extends AbstractEmulatorCLI {
    @Argument(index=0, required=true)
    public String command;

    public TizenEmulatorQMP() {
        this.messageType = "qmp";
    }

    @Override
    public int execute() {
        int ret = 0;
        if (this.messageType != null) {
            EventMgr.getInstance().AddLsn(this.messageType, (ILsn)this);
        }
        ret = this.executeQMP();
        if (this.messageType != null) {
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
        }
        if (this.timerExpired) {
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_RESPONSE);
            return 129;
        }
        if (ret != 0) {
            return ret;
        }
        return this.returnValue;
    }

    private int executeQMP() {
        if (!JsonUtil.messageComplete((String)this.command)) {
            OutputUtil.printError(CLIConstants.ERR_DESC_WRONG_JSON_FORMAT);
            return 26;
        }
        String msg = null;
        try {
            msg = JsonUtil.encodeMonitorString((String)this.command, (String)"qmp");
        }
        catch (ParseException e) {
            OutputUtil.print(CLIConstants.ERR_PRINT + CLIConstants.ERR_DESC_WRONG_JSON_ENCODE + StringResources.NEW_LINE + OutputUtil.getDeviceUsage("qmp"));
            return 26;
        }
        if (msg == null) {
            OutputUtil.print(CLIConstants.ERR_PRINT + CLIConstants.ERR_DESC_WRONG_JSON_ENCODE + StringResources.NEW_LINE + OutputUtil.getDeviceUsage("qmp"));
            return 26;
        }
        MessageSender.getInstance().sendMonitorReq(msg);
        this.startRunning();
        return 0;
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
        Object obj = jsParam.get((Object)"return");
        try {
            if (obj instanceof JSONArray) {
                JSONArray array = (JSONArray)obj;
                OutputUtil.println(array.toJSONString());
            } else {
                OutputUtil.println((String)obj);
            }
        }
        catch (ClassCastException e) {
            this.returnValue = 128;
        }
        this.stopRunning();
    }
}

