/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import com.sun.javafx.PlatformUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.xml.bind.JAXBException;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.ECPParseArgs;
import org.tizen.ecp.ECPProperty;
import org.tizen.ecp.UiMessages;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.device.DeviceManager;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.socket.SocketMessage;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.MacUtil;
import org.tizen.ecp.views.ECPMainPane;

public class EmulatorControlPanel
extends Application {
    private static Logger logger;
    private static RandomAccessFile randomAccessFile;
    private static Stage mainStage;
    private static Window mainWindow;
    private static HostServices hostService;
    private static ECPProperty ecpProperty;
    private static int theNumberOfCards;
    private static int theNumberOfCardCols;
    private static double excessHeight;
    private static double excessWidth;
    private static double scale;
    private static boolean isMinSize;
    private static String vmName;
    private static final URL BASE_CSS_URL;

    private void writeError(String msg) {
        MessageBox.error(msg);
    }

    public static void exit(int status) {
        System.exit(status);
    }

    public static void main(String[] args) {
        EmulatorControlPanel.launch((String[])args);
    }

    public void preRun(String[] args) {
        Map<String, String> argsMap;
        boolean pathInit = false;
        MacUtil.setProperty();
        if (PlatformUtil.isMac()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        if ((argsMap = ECPParseArgs.parseArgs(args)) == null) {
            StringBuilder str = new StringBuilder("Wrong argument. check your args\n");
            for (int i = 0; i < args.length; ++i) {
                str.append(" ").append(args[i]);
            }
            this.writeError(str.toString());
            EmulatorControlPanel.exit(-1);
        }
        if (StringResources.isEmpty(vmName = argsMap.get("vm_name"))) {
            this.writeError(UiMessages.getString("EmulatorControlPanel.22") + UiMessages.getString("EmulatorControlPanel.23"));
            EmulatorControlPanel.exit(-1);
        }
        if (!(pathInit = FilePath.initialize(vmName))) {
            this.writeError("Failed to init Paths. check correct path.");
            EmulatorControlPanel.exit(-1);
        }
        try {
            LogUtil.init(LogUtil.ECPLogLevel.DEBUG, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.writeError(UiMessages.getString("EmulatorControlPanel.24") + e.getMessage() + UiMessages.getString("EmulatorControlPanel.25") + FilePath.getInstance().getDataLogFile());
            EmulatorControlPanel.exit(-1);
        }
        logger.info("!!! Start Emulator Control Panel !!!");
        String lockPath = FilePath.getInstance().getVmsPath() + File.separator + vmName + File.separator + "ecp.lock";
        try {
            randomAccessFile = new RandomAccessFile(new File(lockPath), "rw");
            FileLock lock = randomAccessFile.getChannel().tryLock();
            if (lock == null) {
                this.writeError(UiMessages.getString("EmulatorControlPanel.30") + StringResources.NEW_LINE + UiMessages.getString("EmulatorControlPanel.31"));
                EmulatorControlPanel.exit(-1);
            }
        }
        catch (FileNotFoundException e) {
            logger.severe("Throw exception: " + e.getMessage());
            EmulatorControlPanel.exit(-1);
        }
        catch (IOException e) {
            this.writeError(UiMessages.getString("EmulatorControlPanel.33") + StringResources.NEW_LINE + e.getMessage());
            logger.severe("IOException: " + e.getMessage() + "\n" + lockPath);
            EmulatorControlPanel.exit(-1);
        }
        String profile = VMInfo.getInstance().getProfile();
        if (profile == null || profile.isEmpty()) {
            this.writeError(UiMessages.getString("EmulatorControlPanel.41") + profile + UiMessages.getString("EmulatorControlPanel.42"));
            logger.severe("Can not load profile( " + profile + ")");
            EmulatorControlPanel.exit(-1);
        }
        Path ecpInfoPath = FilePath.getInstance().getPluginXMLPath();
        logger.info("ecpInfoPath: " + ecpInfoPath);
        try {
            ECPInfo.getInstance().initialize(ecpInfoPath);
        }
        catch (JAXBException e) {
            logger.severe("plugin xml file is corrupted.");
            EmulatorControlPanel.exit(-1);
        }
        if (!SocketClient.getInstance().connect(VMInfo.getInstance().getSvrPort())) {
            this.writeError(UiMessages.getString("EmulatorControlPanel.51") + VMInfo.getInstance().getSvrPort() + UiMessages.getString("EmulatorControlPanel.52") + StringResources.NEW_LINE);
            EmulatorControlPanel.exit(-1);
        }
        new Thread(null, new SocketMessage(), "Socket Message Thread").start();
        DeviceManager.getInstance().initialize();
    }

    public void start(final Stage stage) throws Exception {
        List params = this.getParameters().getRaw();
        String[] args = params.toArray(new String[params.size()]);
        this.preRun(args);
        mainStage = stage;
        hostService = this.getHostServices();
        String propPath = FilePath.getInstance().getVmsPath() + File.separator + VMInfo.getInstance().getVMName() + File.separator + "ecp.property";
        ecpProperty = new ECPProperty(propPath);
        ECPMainPane main = new ECPMainPane();
        final Scene scene = main.start(stage);
        final Timeline minSizer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                stage.setMinHeight(336.0 + (mainStage.getHeight() - scene.getHeight()));
                stage.setMinWidth(483.0 + (mainStage.getWidth() - scene.getWidth()));
                isMinSize = true;
            }
        }, new KeyValue[0])});
        minSizer.setCycleCount(1);
        stage.setScene(scene);
        mainWindow = scene.getWindow();
        theNumberOfCards = DeviceManager.getInstance().getDeviceList().size();
        if (mainWindow != null) {
            mainWindow.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    theNumberOfCardCols = Math.min(theNumberOfCards, newValue.intValue() / 161);
                    if (!isMinSize) {
                        minSizer.play();
                    }
                }
            });
            mainWindow.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    if (!isMinSize) {
                        minSizer.play();
                    }
                }
            });
        }
        ChangeListener<Number> packListener = new ChangeListener<Number>(){
            final Timer timer = new Timer();
            TimerTask task = null;
            final long delayTime = 300L;

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (stage.isMaximized()) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Method method = mainWindow.getClass().getMethod("getOutputScaleX", null);
                            Double returnValue = (Double)method.invoke((Object)mainWindow, null);
                            scale = returnValue;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                            logger.warning(e.getMessage() + ": while fetching the outputscale");
                            scale = 1.0;
                        }
                        double tempDim = (stage.getWidth() - scene.getWidth()) * scale;
                        if (tempDim > excessWidth) {
                            excessWidth = tempDim;
                        }
                        if ((tempDim = (stage.getHeight() - scene.getHeight()) * scale) > excessHeight) {
                            excessHeight = tempDim;
                        }
                        double newWidth = 644.0 + excessWidth;
                        stage.setWidth(newWidth);
                        EmulatorControlPanel.this.resizeSceneHeight(2);
                    }
                };
                this.timer.schedule(this.task, 300L);
            }
        };
        if (mainWindow != null) {
            mainWindow.widthProperty().addListener((ChangeListener)packListener);
            mainWindow.heightProperty().addListener((ChangeListener)packListener);
        }
        Platform.setImplicitExit((boolean)true);
        stage.resizableProperty().setValue(Boolean.FALSE);
        stage.show();
        stage.setWidth(stage.getWidth() + 1.0);
        stage.setHeight(stage.getHeight() + 1.0);
    }

    public void resizeSceneHeight(int sizeOfTiles) {
        int maxOfTiles = theNumberOfCardCols != 0 ? theNumberOfCards / theNumberOfCardCols + (theNumberOfCards % theNumberOfCardCols != 0 ? 1 : 0) : theNumberOfCards;
        EmulatorControlPanel.getMainStage().setHeight((double)((sizeOfTiles > maxOfTiles ? maxOfTiles : sizeOfTiles) * 171 + 165) + excessHeight);
    }

    public static Window getMainWindow() {
        return mainWindow;
    }

    public static Stage getMainStage() {
        return mainStage;
    }

    public static HostServices getHostService() {
        return hostService;
    }

    public static ECPProperty getECPProperty() {
        return ecpProperty;
    }

    public static List<String> getBaseCssUrl() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BASE_CSS_URL.toExternalForm());
        return list;
    }

    public static String getVmName() {
        return vmName;
    }

    static {
        excessHeight = -1.0;
        excessWidth = -1.0;
        scale = 1.0;
        isMinSize = false;
        vmName = "";
        logger = LogUtil.getECPLogger(EmulatorControlPanel.class).getLogger();
        BASE_CSS_URL = EmulatorControlPanel.class.getResource("/org/tizen/ecp/base.css");
    }
}

