@ECHO OFF
goto :main

:readInfo
	set sdkInfoPath=%ecp_path%\..\..\..\sdk.info
	set JDK_PATH=%ecp_path%\..\..\..\jdk

	rem extracting the paths from sdk.info
	for /F "delims=" %%a in (!sdkInfoPath!) do (
		set paths=%%a
		for /f "tokens=1,2 delims==" %%b in ("!paths!") do (
	 		if %%b==TIZEN_SDK_DATA_PATH (
				set sdkDataPath=%%c
	 		)
	 		if %%b==JDK_PATH (
				set sdkInfoJDKPath=%%c
	 		)
	 		if %%b==TIZEN_SDK_INSTALLED_PATH (
				set sdkPath=%%c
	 		)
		)		
	)
	goto :eof

:createLogFile
	set hour=%time:~0,2%
	if "%hour:~0,1%" == " " set hour=0%hour:~1,1%

	set min=%time:~3,2%
	if "%min:~0,1%" == " " set min=0%min:~1,1%

	set secs=%time:~6,2%
	if "%secs:~0,1%" == " " set secs=0%secs:~1,1%

	set year=%date:~-4%

	set month=%date:~3,2%
	if "%month:~0,1%" == " " set month=0%month:~1,1%

	set day=%date:~0,2%
	if "%day:~0,1%" == " " set day=0%day:~1,1%

	set fileName=ecpCli%year%%month%%day%%hour%%min%%secs%.txt
	set "logFilePath=%sdkDataPath%\emulator"
	if not exist %logFilePath% (
		mkdir -p "%logFilePath%\%fileName%"
	)
	set "logFile=%logFilePath%\%fileName%"
	set logFileCreated=true
	goto :eof

:updateLogFile
	if !logFileCreated!==false (
		call :createLogFile
	)
	call echo %1>>!logFile!
	goto :eof

:setExecPath
	rem set the java exec path to be used
	rem update javaExec if JDK_PATH specified and exists in sdk.info
	set "logFileCreated=false"
	if exist "%sdkInfoJDKPath%" (
		set JDK_PATH=%sdkInfoJDKPath%
		call :updateLogFile "Using Sdk.info java at !JDK_PATH!"
	) else (
		if not !sdkInfoJDKPath!==!emptyVar! (
			call :updateLogFile "Jdk specified in sdk.info:!sdkInfoJDKPath! does not exist."
		)
	)
	if not exist "!JDK_PATH!" (
		set javaExec=java
		call :updateLogFile "Using System java"
	) else (
		set javaExec=!JDK_PATH!\bin\java
	)

	goto :eof

:main

set sdk_path=%~dp0
setlocal enableDelayedExpansion
IF EXIST !sdk_path! (
	set ecp_path=!sdk_path!
) ELSE (
	set ecp_path=.
)

IF %ecp_path:~-1%==\ SET ecp_path=%ecp_path:~0,-1%

set current_path=%CD%\emulator-control-panel-cli.jar
set current_path_dir=%CD%

call :readInfo
call :setExecPath

IF EXIST "%current_path%" (
	"%javaExec%" -jar "%current_path%" %*
) ELSE (
	"%javaExec%" -jar "%ecp_path%\emulator-control-panel-cli.jar" %* 
)
