/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views.popup;

import java.io.IOException;
import java.net.URL;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.tizen.ecp.EmulatorControlPanel;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.views.popup.ECPPopupModel;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class ECPPopupView {
    protected ECPPopupModel model;
    private boolean init = false;
    private Stage dialog = null;
    private Pane pane = null;
    private static final int BORDER_WIDTH = 1;

    private void initialize(ECPPopupPane ecpPane) {
        if (ecpPane != null) {
            this.pane = ecpPane.create();
            ecpPane.onShow();
        }
        this.dialog = new Stage(StageStyle.UNDECORATED);
        this.dialog.initStyle(StageStyle.TRANSPARENT);
        this.dialog.setResizable(true);
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.initOwner(EmulatorControlPanel.getMainWindow());
        this.model = new ECPPopupModel();
        this.model.setStage(this.dialog);
        this.init = true;
    }

    private Pane createGlobalPopupPane() {
        Pane pane = null;
        URL location = this.getClass().getResource("/org/tizen/ecp/views/popup/ECPPopupView.fxml");
        ECPFXMLLoader loader = new ECPFXMLLoader(location, this.model);
        try {
            pane = (Pane)loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        pane.getStylesheets().add((Object)EmulatorControlPanel.getBaseCssUrl().get(0));
        return pane;
    }

    public void showPopup(String name, int width, int height, ECPPopupPane ecpPane) {
        Pane popupPane = null;
        if (!this.init || this.pane == null) {
            this.initialize(ecpPane);
        }
        Window win = EmulatorControlPanel.getMainWindow();
        this.dialog.setX(win.getX() + (win.getWidth() - (double)width) / 2.0);
        this.dialog.setY(win.getY() + (win.getHeight() - (double)height) / 2.0);
        this.dialog.setWidth((double)(width + 2));
        this.dialog.setMinWidth((double)(width + 2));
        this.dialog.setHeight((double)(height + 2));
        this.dialog.setMinHeight((double)(height + 2));
        this.model.setName(name);
        this.model.setTitle(ecpPane.getTitle());
        this.model.setSize(width, height);
        this.model.setPopupPane(this.pane);
        this.model.setEcpPane(ecpPane);
        popupPane = this.createGlobalPopupPane();
        popupPane.setStyle("-fx-border-color: #008AEE; -fx-border-width: 1; -fx-background-color: white;");
        Scene scene = new Scene((Parent)popupPane);
        this.dialog.setScene(scene);
        this.dialog.showAndWait();
    }

    public void closePopup() {
        ECPPopupPane ecpPane;
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.close();
        }
        if ((ecpPane = this.model.getEcpPane()) != null) {
            ecpPane.onClose();
        }
    }
}

