/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.tizen.ecp.utils.LogUtil;

public class MacUtil {
    private static Logger logger;

    public static void setProperty() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Emulator Control Panel");
    }

    public static void setDockIcon(InputStream is) throws Exception {
        logger = LogUtil.getECPLogger(MacUtil.class).getLogger();
        BufferedImage img = ImageIO.read(is);
        String versionStr = System.getProperty("java.version");
        if (versionStr.startsWith("1.")) {
            logger.info("JDK 8 and below, set icon using 'com.apple.eawt.Application'");
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Method getAppMethod = appClass.getMethod("getApplication", new Class[0]);
            Object appInstance = getAppMethod.invoke(null, new Object[0]);
            Method setIconMethod = appInstance.getClass().getMethod("setDockIconImage", Image.class);
            setIconMethod.invoke(appInstance, img);
        } else {
            logger.info("JDK 9 and above, set icon using 'java.awt.Taskbar'");
            Class<?> taskbarClass = Class.forName("java.awt.Taskbar");
            Method getTaskbarMethod = taskbarClass.getMethod("getTaskbar", new Class[0]);
            Object instance = getTaskbarMethod.invoke(null, new Object[0]);
            Method setIconMethod = instance.getClass().getMethod("setIconImage", Image.class);
            setIconMethod.invoke(instance, img);
        }
    }
}

