/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sock;

import com.google.protobuf.ByteString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.LogUtil;

public class MessageSender {
    private static MessageSender m_inst;
    private static Logger logger;
    private boolean isMessageTimerExpired = true;

    public static MessageSender getInstance() {
        if (null == m_inst) {
            m_inst = new MessageSender();
        }
        return m_inst;
    }

    public void setMessageTimerExpired(boolean isMessageTimerExpired) {
        this.isMessageTimerExpired = isMessageTimerExpired;
    }

    public boolean isMessageTimerExpired() {
        return this.isMessageTimerExpired;
    }

    public synchronized boolean sendMaster(Ecs.Master master) {
        int serialize_size = master.getSerializedSize();
        DataOutputStream outputStream = SocketClient.getInstance().getOutputStream();
        if (outputStream == null) {
            return false;
        }
        try {
            outputStream.writeInt(serialize_size);
            master.writeTo(SocketClient.getInstance().getOutputStream());
            SocketClient.getInstance().getOutputStream().flush();
        }
        catch (IOException e) {
            if (logger != null) {
                logger.warning(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public boolean sendInjectorReq(String cat, int group, int action, byte[] data) {
        if (!SocketClient.getInstance().getGuestStatus()) {
            SocketClient.getInstance().fireGuestOffMessage();
            return false;
        }
        this.isMessageTimerExpired = false;
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.INJECTOR_REQ);
        Ecs.InjectorReq.Builder injectorBuilder = Ecs.InjectorReq.newBuilder();
        injectorBuilder.setCategory(cat);
        injectorBuilder.setLength(data.length);
        injectorBuilder.setGroup(group);
        injectorBuilder.setAction(action);
        if (data.length > 0) {
            ByteString bystr = ByteString.copyFrom((byte[])data);
            injectorBuilder.setData(bystr);
            logger.info("send data = " + new String(bystr.toByteArray(), 0, bystr.size()));
        }
        masterBuilder.setInjectorReq(injectorBuilder);
        Ecs.Master master = masterBuilder.build();
        return this.sendMaster(master);
    }

    public boolean sendInjectorReq(String cat, int group, int action, String data) {
        return this.sendInjectorReq(cat, group, action, data.getBytes());
    }

    public boolean sendInjectorReq(String cat, int group, int action) {
        return this.sendInjectorReq(cat, group, action, "");
    }

    public boolean sendDeviceEcsReq(String cat, int group, int action, String data) {
        this.isMessageTimerExpired = false;
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.DEVICE_REQ);
        Ecs.DeviceReq.Builder deviceBuilder = Ecs.DeviceReq.newBuilder();
        deviceBuilder.setCategory(cat);
        deviceBuilder.setLength(data.length());
        deviceBuilder.setGroup(group);
        deviceBuilder.setAction(action);
        if (data.length() > 0) {
            ByteString bystr = ByteString.copyFrom((byte[])data.getBytes());
            deviceBuilder.setData(bystr);
            if (logger != null) {
                logger.info("send data = " + new String(bystr.toByteArray(), 0, bystr.size()));
            }
        }
        masterBuilder.setDeviceReq(deviceBuilder);
        Ecs.Master master = masterBuilder.build();
        return this.sendMaster(master);
    }

    public boolean sendDeviceReq(String cat, int group, int action, String data) {
        if (!SocketClient.getInstance().getGuestStatus()) {
            SocketClient.getInstance().fireGuestOffMessage();
            return false;
        }
        return this.sendDeviceEcsReq(cat, group, action, data);
    }

    public boolean sendDeviceReq(String cat, int group, int action) {
        return this.sendDeviceReq(cat, group, action, "");
    }

    public boolean sendDeviceEcsReq(String cat, int group, int action) {
        return this.sendDeviceEcsReq(cat, group, action, "");
    }

    public boolean sendMonitorReq(String data) {
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.MONITOR_REQ);
        Ecs.MonitorReq.Builder monitorBuilder = Ecs.MonitorReq.newBuilder();
        monitorBuilder.setCommand(data);
        masterBuilder.setMonitorReq(monitorBuilder);
        Ecs.Master master = masterBuilder.build();
        return this.sendMaster(master);
    }

    public void sendKeepAliveAns() {
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.KEEPALIVE_ANS);
        Ecs.KeepAliveAns.Builder kaBuilder = Ecs.KeepAliveAns.newBuilder();
        kaBuilder.setTimeStr("self");
        masterBuilder.setKeepaliveAns(kaBuilder);
        Ecs.Master master = masterBuilder.build();
        this.sendMaster(master);
    }

    static {
        logger = null;
        LogUtil logUtil = LogUtil.getECPLogger(MessageSender.class);
        if (logUtil != null) {
            logger = logUtil.getLogger();
        }
    }
}

