/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.resources;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.about.About;
import org.tizen.ecp.resources.NoExceptionCallable;
import org.tizen.ecp.resources.ThreadFactory;
import org.tizen.ecp.utils.LogUtil;

abstract class ExecutorServiceDelegate {
    static final ExecutorService executor = Executors.newCachedThreadPool(ThreadFactory.getDaemonThreadFactory());
    private Logger logger = LogUtil.getECPLogger(About.class).getLogger();

    protected ExecutorServiceDelegate() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        List<Runnable> tasks = executor.shutdownNow();
                        ExecutorServiceDelegate.this.logger.log(Level.SEVERE, "ExecutorServiceDelegate: dropped " + tasks.size() + " task(s).");
                        executor.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    protected <T> T executeInternal(Callable<T> task) throws Exception {
        return task.call();
    }

    protected <T> T executeInternal(NoExceptionCallable<T> task) {
        return task.call();
    }

    protected <T> Future<T> asyncExecuteInternal(Callable<T> task) {
        return executor.submit(task);
    }
}

