/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.about;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.about.About;
import org.tizen.ecp.resources.FontKind;
import org.tizen.ecp.resources.Fonts;
import org.tizen.ecp.resources.SimpleExecutor;
import org.tizen.ecp.utils.LogUtil;

public class AboutAction
implements Initializable {
    @FXML
    private Label labTitle1;
    @FXML
    private Label labTitle2;
    @FXML
    private Hyperlink linkTizenSite;
    @FXML
    private GridPane paneTitle;
    @FXML
    private Label labVersion;
    @FXML
    private Label labBuild;
    private static String DEV_SITE = "https://developer.tizen.org";
    private Logger logger = LogUtil.getECPLogger(About.class).getLogger();

    public void initialize(URL location, ResourceBundle resources) {
        this.labTitle1.setFont(Fonts.get(FontKind.FONT_16));
        this.labTitle2.setFont(Fonts.get(FontKind.FONT_32_BOLD));
        String image = this.getClass().getResource("/org/tizen/ecp/about/about_bg.png").toExternalForm();
        this.paneTitle.setStyle("-fx-background-image: url('" + image + "');-fx-background-position: right;-fx-background-repeat: no-repeat;-fx-background-color: #009ee6;");
        About about = About.getInstance();
        this.labVersion.setText(about.getEcpVersion());
        this.labBuild.setText(about.getBuildTime());
        this.linkTizenSite.setText(DEV_SITE);
    }

    @FXML
    public void clickTizenSite(ActionEvent e) {
        SimpleExecutor.asynExecute(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AboutAction.this.logger.log(Level.SEVERE, DEV_SITE);
                    Desktop.getDesktop().browse(new URI(DEV_SITE));
                }
                catch (IOException | URISyntaxException e) {
                    AboutAction.this.logger.log(Level.SEVERE, e.getMessage());
                }
                return null;
            }
        });
    }
}

