/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.json.simple.JSONObject;
import org.tizen.ecp.ECPProperty;
import org.tizen.ecp.EmulatorControlPanel;
import org.tizen.ecp.device.DeviceManager;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;

public class ECPMainPane
implements IConnection,
ILsn {
    private Logger logger;
    EventHandler<WindowEvent> closeEvent = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            ECPProperty ecpProperty = EmulatorControlPanel.getECPProperty();
            Window win = EmulatorControlPanel.getMainWindow();
            ecpProperty.setProperty("window.x", Double.toString(win.getX()));
            ecpProperty.setProperty("window.y", Double.toString(win.getY()));
            ecpProperty.setProperty("window.width", Double.toString(win.getWidth()));
            ecpProperty.setProperty("window.height", Double.toString(win.getHeight()));
            ecpProperty.storeProperty();
            Platform.exit();
            System.exit(0);
        }
    };

    private void setMainStage(Stage stage) {
        double height;
        double width;
        double y;
        double x;
        ECPProperty ecpProperty = EmulatorControlPanel.getECPProperty();
        try {
            x = Double.parseDouble(ecpProperty.getPropertyString("window.x"));
            y = Double.parseDouble(ecpProperty.getPropertyString("window.y"));
            width = Double.parseDouble(ecpProperty.getPropertyString("window.width"));
            height = Double.parseDouble(ecpProperty.getPropertyString("window.height"));
        }
        catch (Exception e) {
            x = 100.0;
            y = 100.0;
            width = 700.0;
            height = 600.0;
        }
        stage.setX(x);
        stage.setY(y);
        stage.setWidth(width);
        stage.setHeight(height);
        String vmName = EmulatorControlPanel.getVmName();
        if (vmName.isEmpty()) {
            stage.setTitle("Emulator Control Panel");
        } else {
            stage.setTitle(vmName + " - " + "Emulator Control Panel");
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("icon/ecp.png");
        if (is != null) {
            stage.getIcons().add((Object)new Image(is));
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Scene start(Stage stage) throws Exception {
        Pane mainView = (Pane)FXMLLoader.load((URL)this.getClass().getResource("/org/tizen/ecp/views/ECPMainPane.fxml"));
        mainView.getStylesheets().add((Object)EmulatorControlPanel.getBaseCssUrl().get(0));
        Scene scene = new Scene((Parent)mainView);
        this.setMainStage(stage);
        stage.setOnCloseRequest(this.closeEvent);
        SocketClient.getInstance().registerDisconnectListener(this);
        EventMgr.getInstance().AddLsn("cap", this);
        MessageSender.getInstance().sendDeviceReq("cap", 0, 0);
        return scene;
    }

    @Override
    public void disconnected() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Stage stage = EmulatorControlPanel.getMainStage();
                EventHandler event = stage.getOnCloseRequest();
                if (event != null) {
                    event.handle((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
                }
            }
        });
    }

    @Override
    public void guestOn() {
    }

    @Override
    public void guestOff() {
    }

    @Override
    public void guestOffMessage() {
    }

    @Override
    public void OnStatusEventProcPB(GeneratedMessage param) {
        if (param instanceof Ecs.DeviceNtf) {
            Ecs.DeviceNtf ntf = (Ecs.DeviceNtf)param;
            String cat = ((Ecs.DeviceNtf)param).getCategory();
            if ("cap".equals(cat)) {
                final String data = ntf.getData().toStringUtf8();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DeviceManager.getInstance().setCapabilities(data);
                    }
                });
            }
        }
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
    }
}

