/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.tizen.emulator.manager.vms.ListChangeListener;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;

public class VMAvailabilityMonitor
implements Runnable,
ListChangeListener<VMProperty> {
    private static VMAvailabilityMonitor instance;
    private final Queue<VMProperty> suspects = new ConcurrentLinkedQueue<VMProperty>();

    VMAvailabilityMonitor() throws IOException {
        VMKeeper.addListChangeListener(this);
    }

    public static synchronized void initialize() throws IOException {
        assert (instance == null);
        instance = new VMAvailabilityMonitor();
        MonitoringThread.newMonitoringThread(instance, "VMAvailabilityMonitor").start();
    }

    @Override
    public void elementAdded(VMProperty property) {
        this.checkAvailability(property);
        this.suspects.add(property);
    }

    @Override
    public void elementRemoved(VMProperty property) {
        this.suspects.remove(property);
    }

    @Override
    public void elementModified(VMProperty object) {
    }

    private void checkAvailability(VMProperty property) {
        if (property.getHealth() == VMProperty.Health.CORRUPTED) {
            return;
        }
        VMProperty.Health health = this.isDiskImageAvailable(property.getPropertyValue()) ? VMProperty.Health.WELL : VMProperty.Health.PLATFORM_IMAGE_NOT_ACCESSIBLE;
        if (property.getPropertyValue().getPlatform().isNotAvailabale()) {
            health = VMProperty.Health.PLATFORM_IS_NOT_AVAILABLE;
        }
        if (property.getHealth() != health) {
            property.setHealth(health);
        }
    }

    private boolean isDiskImageAvailable(VMPropertyValue value) {
        Path childImagePath;
        for (String path : value.getImagePathList()) {
            if (Files.isReadable(Paths.get(path, new String[0]))) continue;
            return false;
        }
        return !value.useQCOW2() || Files.isReadable(childImagePath = Paths.get(value.childImagePath, new String[0]));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) lbl-1000:
        // 4 sources

        {
            for (VMProperty property : this.suspects) {
                this.checkAvailability(property);
            }
            try {
                Thread.sleep(500L);
                ** continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

