/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.type;

import java.util.ArrayList;
import org.tizen.emulator.manager.logging.EMLogger;

public class CPU {
    private static int cpuNum;
    private static final ArrayList<CPU> list;
    private String id;
    private int value;

    public static int getMaxCpuNum() {
        if (list == null) {
            return 1;
        }
        return list.get(list.size() - 1).getValue();
    }

    public static ArrayList<CPU> values() {
        return list;
    }

    private CPU(String id, int value) {
        this.id = id;
        this.value = value;
    }

    private static int findTotalCpu() throws Exception {
        Runtime rt = Runtime.getRuntime();
        int pn = rt.availableProcessors();
        return pn;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.id;
    }

    static {
        list = new ArrayList();
        try {
            cpuNum = CPU.findTotalCpu();
        }
        catch (Exception e) {
            EMLogger.getLogger().warning("Throw exception: " + e.getMessage());
            EMLogger.printStackTrace(e);
        }
        for (int i = 1; i <= cpuNum; ++i) {
            if (cpuNum % i != 0) continue;
            list.add(new CPU(Integer.toString(i), i));
        }
    }
}

