/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.CheckVMOption;
import org.tizen.emulator.manager.console.processor.ConsoleException;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateList;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.Creator;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.EmptyStringException;
import org.tizen.emulator.manager.vms.exception.UserCanceledException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class ConsoleCreateVM {
    private String platformName = null;
    private String deviceName = null;
    private String imagePath = null;
    private String rawImagePath = null;
    private boolean needPrintPlatformList = false;
    private boolean needPrintDeviceList = false;
    private boolean isDefaultName = false;

    public boolean createVM(ArrayList<Option> list) {
        boolean isStandard = true;
        boolean setPlatform = false;
        for (Option c : list) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 't': {
                    this.deviceName = c.getCurrentValue();
                    break;
                }
                case 'p': {
                    setPlatform = true;
                    this.platformName = c.getCurrentValue();
                    break;
                }
                case 'c': {
                    isStandard = false;
                    this.imagePath = c.getCurrentValue();
                    break;
                }
                case 'a': {
                    isStandard = false;
                    this.rawImagePath = c.getCurrentValue();
                    break;
                }
                case 'd': {
                    this.isDefaultName = true;
                }
            }
        }
        if (!setPlatform && PlatformList.getList().size() > 1) {
            OutputUtil.printError(Messages.getString("ConsoleCreateVM.Error.ChoosePlatform"));
            this.printAvailablePlatforms();
            return false;
        }
        Platform platform = null;
        try {
            platform = isStandard ? this.getStandardPlatform() : this.getCustomPlatform();
            this.createEmulator(platform, list);
        }
        catch (ConsoleException e) {
            OutputUtil.printError(e.getMessage());
            if (this.needPrintPlatformList) {
                this.printAvailablePlatforms();
            }
            if (this.needPrintDeviceList) {
                this.printAvailableDevices(platform);
            }
            return false;
        }
        catch (UserCanceledException e1) {
            OutputUtil.print(e1.getMessage());
        }
        return true;
    }

    private Platform getStandardPlatform() throws ConsoleException {
        Platform platform = null;
        platform = this.platformName == null ? PlatformList.getList().first() : PlatformList.get(this.platformName);
        if (platform == null) {
            this.needPrintPlatformList = true;
            throw new ConsoleException(this.platformName + " " + Messages.getString("ConsoleCreateVM.Error.NotExistPlatform"));
        }
        return platform;
    }

    private Platform getCustomPlatform() throws ConsoleException, UserCanceledException {
        CustomPlatformImageValue value;
        Platform platform = null;
        Platform basePlatform = null;
        basePlatform = this.platformName == null ? PlatformList.getList().first() : PlatformList.get(this.platformName);
        if (basePlatform == null) {
            this.needPrintPlatformList = true;
            throw new ConsoleException(this.platformName + " " + Messages.getString("ConsoleCreateVM.Error.NotExistPlatform"));
        }
        if (this.imagePath != null) {
            this.imagePath = this.checkImagePath(this.imagePath);
            value = new CustomPlatformImageValue(this.imagePath, basePlatform);
        } else {
            List<String> pathList = this.getRawImagePathList(this.rawImagePath);
            value = new CustomPlatformImageValue(pathList, basePlatform);
        }
        platform = Platform.createTemporaryCustomInstance(value);
        if (platform == null) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.CustomPlatform"));
        }
        return platform;
    }

    private void createEmulator(Platform platform, ArrayList<Option> list) throws ConsoleException {
        if (platform == null) {
            this.needPrintPlatformList = true;
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.ChoosePlatform"));
        }
        VMPropertyValue property = null;
        property = VMPropertyValue.createValueForNewVM(platform, platform.getDefaultProperty());
        DeviceTemplate template = null;
        if (this.deviceName != null) {
            this.deviceName = this.deviceName.replace("-", " ");
            template = DeviceTemplateList.findDeviceTemplateByName(this.deviceName);
        } else {
            template = DeviceTemplateList.findDefaultTemplate(platform);
        }
        if (template == null) {
            this.needPrintDeviceList = true;
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NotExistDevice"));
        }
        String profile = template.getValue().getProfile();
        if (profile == null || !profile.equals(property.getProfile())) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NotMatchProfile"));
        }
        property.setDeviceTemplate(template);
        CheckVMOption checkOption = new CheckVMOption();
        for (Option c : list) {
            if (!c.isInCommandLine()) continue;
            if (c.getShortName().equals("n")) {
                if (this.isDefaultName && HelperClass.checkReservedName(c.getCurrentValue())) {
                    return;
                }
                property.vmName = this.checkVMName(c.getCurrentValue(), this.isDefaultName);
                continue;
            }
            checkOption.setOptions(c, property);
        }
        if (property.skin == null) {
            property.skin = platform.getAvailableSkin(property.resolution);
        }
        if (property.skin != null) {
            property.skinPath = property.skin.getPath();
        }
        try {
            Creator.create(property);
        }
        catch (VMWorkerException e) {
            throw new ConsoleException(e.getMessage());
        }
        OutputUtil.print(Messages.getString("ConsoleCreateVM.SuccessCreate"));
    }

    private void printAvailableDevices(Platform platform) {
        OutputUtil.print("");
        Profile profile = null;
        if (platform != null) {
            profile = platform.getProfile();
        }
        if (profile == null) {
            OutputUtil.print("Available devices");
        } else {
            OutputUtil.print("Available devices of " + profile.getName());
        }
        new ConsoleProcessor().printDeviceList(profile, false);
    }

    private void printAvailablePlatforms() {
        OutputUtil.print("");
        OutputUtil.print("Available platform");
        new ConsoleProcessor().printPlatformList(null, false);
    }

    private String checkImagePath(String value) throws ConsoleException {
        if (value == null || value.isEmpty()) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.EmptyImagePath"));
        }
        File f = new File(value);
        if (!f.exists()) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NotExistImagePath") + StringResources.NEW_LINE + "Path: " + value);
        }
        if (!HelperClass.isAvailablePath(value)) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NotAvailableImage.1") + StringResources.NEW_LINE + Messages.getString("ConsoleCreateVM.Error.NotAvailableImage.2"));
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ConsoleException(e.getMessage());
        }
    }

    private List<String> getRawImagePathList(String value) throws ConsoleException, UserCanceledException {
        if (value == null || value.isEmpty()) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.EmptyImagePath"));
        }
        File f = new File(value);
        if (!f.exists()) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NotExistImagePath") + StringResources.NEW_LINE + "Path: " + value);
        }
        if (!f.isDirectory()) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NotADirectory"));
        }
        ArrayList<String> rawImagePathList = new ArrayList<String>();
        for (File file : f.listFiles()) {
            if (!file.getName().endsWith(".img")) continue;
            try {
                rawImagePathList.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
                throw new ConsoleException(e.getMessage());
            }
        }
        if (rawImagePathList.isEmpty()) {
            throw new ConsoleException(Messages.getString("ConsoleCreateVM.Error.NoRawImageFiles"));
        }
        this.showRawDiskImageWarning(rawImagePathList);
        return rawImagePathList;
    }

    private void showRawDiskImageWarning(List<String> rawImagePathList) throws UserCanceledException {
        block4: {
            System.out.println(Messages.getString("ConsoleCreateVM.Info.UseRawDiskImage1"));
            for (String path : rawImagePathList) {
                System.out.println(" - " + path.substring(path.lastIndexOf(File.separator) + 1));
            }
            System.out.println(Messages.getString("ConsoleCreateVM.Info.UseRawDiskImage2") + StringResources.NEW_LINE + Messages.getString("ConsoleCreateVM.Info.UseRawDiskImage3") + StringResources.NEW_LINE + Messages.getString("ConsoleCreateVM.Info.UseRawDiskImage4"));
            int input = 0;
            do {
                try {
                    input = (char)new BufferedReader(new InputStreamReader(System.in)).read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (input == 121 || input == 89) break block4;
            } while (input != 110 && input != 78);
            throw new UserCanceledException(Messages.getString("ConsoleCreateVM.Error.UserCanceled"));
        }
    }

    private String checkVMName(String name, boolean isDefault) throws ConsoleException {
        try {
            HelperClass.checkVMName(name, isDefault);
        }
        catch (EmptyStringException | VMWorkerException e) {
            throw new ConsoleException(e.getMessage());
        }
        return name;
    }
}

