/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.monitor.ECSSocket;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;
import org.tizen.emulator.manager.vms.monitor.RunningMonitor;
import org.tizen.emulator.manager.vms.monitor.VMSocketQueue;

final class ECSMonitor
extends RunningMonitor {
    protected final VMKeeper keeper;
    private final VMSocketQueue registeringQueue = new VMSocketQueue();
    private final Selector selector;
    private final List<ECSSocket> sockets = new ArrayList<ECSSocket>();

    ECSMonitor() throws IOException {
        this.keeper = EmulatorManager.getVMKeeper();
        this.selector = Selector.open();
        for (int i = 26103; i < 26194; i += 10) {
            this.sockets.add(new ECSSocket(i));
        }
        MonitoringThread.newMonitoringThread(new ConnetionMonitor(), "ECSConnectionMonitor").start();
        MonitoringThread.newMonitoringThread(new SocketMonitor(), "ECSSocketMonitor").start();
        VMKeeper.addListChangeListener(this);
    }

    @Override
    public void elementAdded(VMProperty property) {
        if (!this.isMonitoringTarget(property)) {
            return;
        }
        this.initPropertyState(property);
        for (ECSSocket ecsSocket : this.sockets) {
            Path path = ecsSocket.getPath();
            if (!this.isImagePathEquals(property, path)) continue;
            this.updateState(property, true, RunningMonitor.MonitoringType.ECS);
            ecsSocket.setMonitored(true);
            return;
        }
    }

    @Override
    public void elementRemoved(VMProperty property) {
        for (ECSSocket ecsSocket : this.sockets) {
            Path path = ecsSocket.getPath();
            if (!this.isImagePathEquals(property, path)) continue;
        }
    }

    @Override
    public void elementModified(VMProperty object) {
    }

    private void addToRegisterQueue(ECSSocket socket, int ops) {
        this.registeringQueue.add(socket, ops);
        this.selector.wakeup();
    }

    private boolean isMonitoringTarget(VMProperty property) {
        return property.getPropertyValue().getPlatform().getVersion().compareTo("3") < 0;
    }

    private boolean updateState(Path imagePath, boolean isRunningDetected) {
        for (VMProperty property : this.keeper.getProperties()) {
            if (!this.isImagePathEquals(property, imagePath)) continue;
            if (!this.isMonitoringTarget(property)) break;
            this.updateState(property, isRunningDetected, RunningMonitor.MonitoringType.ECS);
            return true;
        }
        return false;
    }

    private boolean isImagePathEquals(VMProperty property, Path imagePath) {
        VMPropertyValue value = property.getPropertyValue();
        if (value.useQCOW2()) {
            return Paths.get(value.childImagePath, new String[0]).equals(imagePath);
        }
        for (String rawImagePath : value.getImagePathList()) {
            if (!Paths.get(rawImagePath, new String[0]).equals(imagePath)) continue;
            return true;
        }
        return false;
    }

    private void runningVMDetected(String path, ECSSocket vms) {
        Path vmPath = Paths.get(path, new String[0]);
        vms.setPath(vmPath);
        if (this.updateState(vmPath, true)) {
            vms.setMonitored(true);
        }
    }

    private void disconnect(ECSSocket vms) {
        vms.disconnect();
        if (vms.isMonitored()) {
            this.updateState(vms.getPath(), false);
        }
        vms.reset();
    }

    static /* synthetic */ List access$000(ECSMonitor x0) {
        return x0.sockets;
    }

    final class SocketMonitor
    implements Runnable {
        private final ByteBuffer length = ByteBuffer.allocate(4);
        private int readLength = 0;

        SocketMonitor() {
        }

        private void registerSocket() {
            VMSocketQueue.QueueObject queueObject;
            while ((queueObject = ECSMonitor.this.registeringQueue.poll()) != null) {
                ECSSocket socket = queueObject.socket;
                SocketChannel sc = socket.getSocket();
                try {
                    sc.register(ECSMonitor.this.selector, queueObject.ops, socket);
                }
                catch (Exception e) {
                    EMLogger.getLogger().warning(e.getMessage());
                    ECSMonitor.this.disconnect(socket);
                }
                if (queueObject.ops != 1) continue;
                socket.sendDeviceReq();
            }
            return;
        }

        private void readBuffer(SelectionKey key) {
            block12: {
                SocketChannel sc = (SocketChannel)key.channel();
                ECSSocket vms = (ECSSocket)key.attachment();
                if (vms == null) {
                    return;
                }
                this.length.clear();
                try {
                    ByteBuffer buffer = vms.getRecvBuffer();
                    int remainingLength = vms.getRemainingDataSize();
                    if (remainingLength == 0) {
                        buffer.clear();
                        this.readLength = sc.read(this.length);
                        if (this.readLength == -1) {
                            ECSMonitor.this.disconnect(vms);
                            return;
                        }
                        this.length.position(0);
                        remainingLength = this.length.getInt();
                        buffer.limit(remainingLength);
                    }
                    this.readLength = sc.read(buffer);
                    if (this.readLength == -1) {
                        ECSMonitor.this.disconnect(vms);
                        return;
                    }
                    vms.setRemainingDataSize(remainingLength -= this.readLength);
                    if (remainingLength > 0) {
                        EMLogger.getLogger().info("Need to receive rest of data. Length in header : " + buffer.limit() + ",  read : " + this.readLength + ",  remain : " + remainingLength);
                        return;
                    }
                    buffer.flip();
                    buffer.position(0);
                    byte[] buff = new byte[buffer.limit()];
                    buffer.get(buff);
                    Ecs.Master msg = Ecs.Master.parseFrom(buff);
                    if (msg.getType() == EcsIds.Master_Type.DEVICE_ANS) {
                        Ecs.DeviceAns ans = msg.getDeviceAns();
                        if (ans.getCategory().equals("info")) {
                            String path = new String(ans.getData().toByteArray(), Charset.forName(System.getProperty("file.encoding")));
                            EMLogger.getLogger().info("ecs response : " + path);
                            ECSMonitor.this.runningVMDetected(path, vms);
                        }
                    } else if (msg.getType() == EcsIds.Master_Type.KEEPALIVE_REQ) {
                        vms.sendKeepAliveAns();
                    }
                }
                catch (IOException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                    ECSMonitor.this.disconnect(vms);
                }
                catch (IllegalArgumentException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                    if (this.length == null) break block12;
                    EMLogger.getLogger().warning("Socket Msg length : " + this.length.getInt());
                }
            }
        }

        private void checkConnection(SelectionKey key) {
            SocketChannel sc = (SocketChannel)key.channel();
            ECSSocket vms = (ECSSocket)key.attachment();
            try {
                if (sc.finishConnect()) {
                    ECSMonitor.this.addToRegisterQueue(vms, 1);
                } else {
                    ECSMonitor.this.disconnect(vms);
                }
            }
            catch (IOException e) {
                ECSMonitor.this.disconnect(vms);
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block4: while (true) {
                        ECSMonitor.this.selector.select();
                        this.registerSocket();
                        Iterator<SelectionKey> it = ECSMonitor.this.selector.selectedKeys().iterator();
                        while (true) {
                            if (!it.hasNext()) continue block4;
                            SelectionKey key = it.next();
                            if (key.isConnectable()) {
                                this.checkConnection(key);
                            } else if (key.isReadable()) {
                                this.readBuffer(key);
                            } else {
                                ECSSocket vms = (ECSSocket)key.attachment();
                                if (vms != null) {
                                    ECSMonitor.this.disconnect(vms);
                                }
                            }
                            it.remove();
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    EMLogger.getLogger().warning("Selector exception: " + e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    EMLogger.getLogger().warning(e.getClass().getName() + " : " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    }

    final class ConnetionMonitor
    implements Runnable {
        ConnetionMonitor() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) lbl-1000:
            // 7 sources

            {
                for (ECSSocket s : ECSMonitor.access$000(ECSMonitor.this)) {
                    if (s.getSocket() != null && (s.getSocket().isConnected() || s.getSocket().isConnectionPending()) || s.getSocket() != null) continue;
                    if (s.tryConnect()) {
                        try {
                            s.getSocket().finishConnect();
                        }
                        catch (IOException e) {
                            EMLogger.getLogger().warning(e.getMessage());
                        }
                        ECSMonitor.access$100(ECSMonitor.this, s, 1);
                        continue;
                    }
                    if (s.getSocket() == null || !s.getSocket().isConnectionPending()) continue;
                    ECSMonitor.access$100(ECSMonitor.this, s, 8);
                }
                try {
                    Thread.sleep(500L);
                    ** continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

