/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.resources.FilePathResources;

class Launch
extends Command {
    private final OverridingVariales variablesCommand;

    public Launch() {
        this.command = "launch";
        this.shortDescription = Messages.getString("Launch.ShortDescription");
        this.description = Messages.getString("Launch.Description");
        this.usage = Messages.getString("Launch.Usage.1") + StringResources.NEW_LINE + Messages.getString("Launch.Usage.2");
        this.optionList.add(new Option("n", "name", StringResources.DESC_LAUNCH_NAME, "", true, true, "NAME"));
        this.optionList.add(new Option("p", "emulator-path", StringResources.DESC_LAUNCH_PATH, FilePathResources.getPlatformsPath() + File.separator + "tizen-[VERSION]" + File.separator + "common" + File.separator + "emulator" + File.separator + "bin", false, true, "PATH"));
        this.variablesCommand = new OverridingVariales("", "", "", "", false, true);
    }

    @Override
    public boolean process() {
        String name = null;
        String path = null;
        for (Option c : this.optionList) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 'n': {
                    name = c.getCurrentValue();
                    break;
                }
                case 'p': {
                    path = c.getCurrentValue();
                }
            }
        }
        ConsoleProcessor processor = new ConsoleProcessor();
        return processor.launchEmulator(name, path, this.variablesCommand.isInCommandLine() ? this.variablesCommand.getVariables() : null);
    }

    @Override
    public Option findLongNameOption(String a) {
        Option c = super.findLongNameOption(a);
        if (c == null) {
            this.variablesCommand.setCurrentValue("--" + a);
            return this.variablesCommand;
        }
        return c;
    }

    class OverridingVariales
    extends Option {
        private final List<String> variables;

        public OverridingVariales(String shortName, String longName, String description, String defaultValue, boolean isMandatory, boolean needsExtra) {
            super(shortName, longName, description, defaultValue, isMandatory, needsExtra);
            this.variables = new ArrayList<String>();
        }

        @Override
        public void setCurrentValue(String value) {
            this.variables.add(value);
        }

        @Override
        public String getCurrentValue() {
            return "";
        }

        public List<String> getVariables() {
            return this.variables;
        }
    }
}

