/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console.processor;

import java.io.File;
import java.util.List;
import org.tizen.emulator.manager.concurrent.overseer.CheckGPU;
import org.tizen.emulator.manager.concurrent.overseer.CheckVT;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleException;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.type.RAM_SIZE;
import org.tizen.emulator.manager.vms.type.SKIN_TYPE;

public class CheckVMOption {
    public void setOptions(Option c, VMPropertyValue prop) throws ConsoleException {
        if (c.getLongName() == "skin") {
            prop.skin = this.checkSkin(c.getCurrentValue(), prop);
        } else if (c.getLongName() == "ram-size") {
            prop.ramSize = this.checkRAMSize(c.getCurrentValue()).getSize();
        } else if (c.getLongName() == "file-sharing-path") {
            if (c.getCurrentValue().isEmpty()) {
                prop.isFileShareSupport = false;
                prop.fileSharePath = "";
            } else {
                this.checkFileSharePath(c.getCurrentValue());
                prop.isFileShareSupport = true;
                prop.fileSharePath = c.getCurrentValue();
            }
        } else if (c.getLongName() == "hw-virtualization") {
            prop.isHWVirtualization = this.checkHWVirtualization(c.getCurrentValue());
        } else if (c.getLongName() == "hw-gl-acceleration") {
            prop.isGLAcceleration = this.checkGLAcceleration(c.getCurrentValue());
        }
    }

    private Skin checkSkin(String value, VMPropertyValue prop) throws ConsoleException {
        List<Skin> skinList = prop.getPlatform().getSkinList(prop.resolution);
        if (skinList == null || skinList.isEmpty()) {
            return null;
        }
        SKIN_TYPE type = null;
        if (Integer.toString(1).equals(value)) {
            type = SKIN_TYPE.GENERAL;
        } else if (Integer.toString(2).equals(value)) {
            type = SKIN_TYPE.PROFILE_SPECIFIC;
        }
        if (type == null) {
            throw new ConsoleException(value + " " + Messages.getString("CheckVMOptoin.Error.Skin.NotExistType.1") + StringResources.NEW_LINE + Messages.getString("CheckVMOptoin.Error.Skin.NotExistType.2") + StringResources.NEW_LINE + Messages.getString("CheckVMOptoin.Skin.GerneralType.1") + StringResources.NEW_LINE + Messages.getString("CheckVMOptoin.Skin.ProfileType.1"));
        }
        for (Skin s : skinList) {
            if (s.getType() != type) continue;
            return s;
        }
        if (type == SKIN_TYPE.GENERAL) {
            OutputUtil.print(Messages.getString("CheckVMOptoin.Skin.GerneralType.2") + " " + Messages.getString("CheckVMOptoin.Error.Skin.NotExist.1"));
        } else if (type == SKIN_TYPE.PROFILE_SPECIFIC) {
            OutputUtil.print(Messages.getString("CheckVMOptoin.Skin.ProfileType.2") + " " + Messages.getString("CheckVMOptoin.Error.Skin.NotExist.1"));
        }
        OutputUtil.print(Messages.getString("CheckVMOptoin.Error.Skin.NotExist.2"));
        return null;
    }

    private boolean checkGLAcceleration(String currentValue) throws ConsoleException {
        String value = currentValue.toLowerCase();
        if (value.equals("yes")) {
            if (!CheckGPU.isGPUSupported()) {
                throw new ConsoleException(Messages.getString("CheckVMOptoin.Error.GPU.NotSupport"));
            }
            return true;
        }
        if (value.equals("no")) {
            return false;
        }
        throw new ConsoleException(Messages.getString("CheckVMOption.Error.GPU.NotVaild.1") + currentValue + StringResources.NEW_LINE + Messages.getString("CheckVMOption.Error.GPU.NotVaild.2"));
    }

    private boolean checkHWVirtualization(String currentValue) throws ConsoleException {
        String value = currentValue.toLowerCase();
        if (value.equals("yes")) {
            if (!CheckVT.isVTSupported()) {
                throw new ConsoleException(Messages.getString("CheckVMOption.Error.VT.NotSupport"));
            }
            return true;
        }
        if (value.equals("no")) {
            return false;
        }
        throw new ConsoleException(Messages.getString("CheckVMOption.Error.VT.NotVaild.1") + currentValue + StringResources.NEW_LINE + Messages.getString("CheckVMOption.Error.VT.NotVaild.2"));
    }

    private RAM_SIZE checkRAMSize(String value) throws ConsoleException {
        String sizes = "";
        for (RAM_SIZE r : RAM_SIZE.values()) {
            if (r.toString().equals(value)) {
                return r;
            }
            if (!sizes.isEmpty()) {
                sizes = sizes + ", ";
            }
            sizes = sizes + r.toString();
        }
        throw new ConsoleException(value + " " + Messages.getString("CheckVMOption.Error.RAM.NotVaild.1") + StringResources.NEW_LINE + Messages.getString("CheckVMOption.Error.RAM.NotVaild.2") + " " + sizes + ".");
    }

    private void checkFileSharePath(String value) throws ConsoleException {
        if (value == null) {
            throw new ConsoleException(Messages.getString("CheckVMOption.Error.FileShare.EmptyPath"));
        }
        File f = new File(value);
        if (!f.exists()) {
            throw new ConsoleException(Messages.getString("CheckVMOption.Error.FileShare.NotExistPath") + StringResources.NEW_LINE + "Path: " + value);
        }
    }
}

