/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.concurrent.overseer.CheckWebcam;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class CameraTypeItemController
extends ComboViewController {
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            CameraTypeItemController.this.reset(event.newValue);
        }
    };
    private String cameraType = "(none)";
    private boolean isRear = "rearType".equals(this.getName());

    public CameraTypeItemController(Item item) {
        super(item);
        if (this.isRear) {
            ViewItemController.addChangeEventHandler("frontType", this.handler);
        } else {
            ViewItemController.addChangeEventHandler("rearType", this.handler);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isRear) {
            ViewItemController.removeChangeEventHandler("frontType", this.handler);
        } else {
            ViewItemController.removeChangeEventHandler("rearType", this.handler);
        }
    }

    @Override
    public void setViewItem(ViewItem item) {
        super.setViewItem(item);
        this.initCombo();
    }

    private void initCombo() {
        if (CheckWebcam.isWebcamSupport()) {
            this.comboView.addItem("Webcam");
        }
        this.comboView.addItem("Virtual");
        this.comboView.addItem("(none)");
    }

    @Override
    protected void onChangedValue(Event event) {
        this.cameraType = this.comboView.getSelectedItem();
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = this.cameraType;
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.cameraType = value.getSubItemStringValue("camera", this.getName());
        if (this.mode == MODE.CREATE || this.cameraType.isEmpty()) {
            this.cameraType = this.isRear && CheckWebcam.isWebcamSupport() ? "Webcam" : "Virtual";
        }
        this.comboView.selectItem(this.cameraType);
        this.onChangedValue(new Event(EventType.Selection));
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setSubItemStringValue("camera", this.getName(), this.cameraType);
    }

    @Override
    public void checkValid() {
    }

    private void reset(String anotherCameraType) {
        if ("Webcam".equals(anotherCameraType)) {
            this.comboView.removeItem(anotherCameraType);
            this.comboView.selectItem(this.cameraType);
        } else {
            if (!CheckWebcam.isWebcamSupport() || this.comboView.isExist("Webcam")) {
                return;
            }
            this.comboView.addItem("Webcam", 0);
            this.comboView.selectItem(this.cameraType);
        }
    }
}

