/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.io.File;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.FileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class CameraImageItemController
extends FileViewController {
    private static final String DEFAULT_FRONT_IMG = "default-image1.gif";
    private static final String DEFAULT_REAR_IMG = "default-image2.gif";
    private String defaultPath = "";
    private String cameraType = "(none)";
    private EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            CameraImageItemController.this.cameraType = event.newValue;
            if (CameraImageItemController.this.defaultPath.isEmpty()) {
                CameraImageItemController.this.defaultPath = FilePathResources.getToolEmulatorImagesPath() + File.separator + ("frontImage".equals(CameraImageItemController.this.getName()) ? CameraImageItemController.DEFAULT_FRONT_IMG : CameraImageItemController.DEFAULT_REAR_IMG);
            }
            if (CameraImageItemController.this.cameraType.equals("Virtual")) {
                if (CameraImageItemController.this.fileItem.getFileName().isEmpty()) {
                    CameraImageItemController.this.fileItem.setFile(new File(CameraImageItemController.this.defaultPath));
                }
            } else {
                CameraImageItemController.this.fileItem.setFile(null);
            }
            CameraImageItemController.this.checkValid();
        }
    };

    public CameraImageItemController(Item item) {
        super(item);
        if (item.getName().equals("rearImage")) {
            ViewItemController.addChangeEventHandler("rearType", this.handler);
        } else {
            ViewItemController.addChangeEventHandler("frontType", this.handler);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.item.getName().equals("rearImage")) {
            ViewItemController.removeChangeEventHandler("rearType", this.handler);
        } else {
            ViewItemController.removeChangeEventHandler("frontType", this.handler);
        }
    }

    @Override
    public void setViewItem(ViewItem item) {
        super.setViewItem(item);
        this.fileItem.setInitialDirectory(FilePathResources.getToolEmulatorImagesPath());
        this.fileItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                CameraImageItemController.this.checkValid();
            }
        });
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        if (this.mode == MODE.CREATE) {
            return;
        }
        String path = value.getSubItemStringValue("camera", this.getName());
        if (path == null || path.isEmpty()) {
            this.fileItem.setFile(null);
        } else {
            this.fileItem.setFile(new File(path));
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setSubItemStringValue("camera", this.getName(), this.fileItem.getFilePath());
    }

    @Override
    public void checkValid() {
        String msg = "";
        if (!this.cameraType.equals("Virtual")) {
            if (this.state != STATE.OK) {
                this.state = STATE.OK;
                this.fileItem.setFile(null);
                this.fileItem.setState(this.state, "");
            }
            this.fileItem.setEnable(false);
            return;
        }
        File file = this.fileItem.getSelectedFile();
        if (file == null || !file.exists()) {
            msg = Messages.getString("CameraImageSubViewItem.ImageFileError.1");
        }
        if (!msg.isEmpty()) {
            this.setState(STATE.ERROR);
            this.fileItem.setState(this.state, msg);
        } else if (this.state != STATE.OK) {
            this.setState(STATE.OK);
            this.fileItem.setState(this.state, "");
        }
        this.fileItem.setEnable(true);
    }
}

