/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.platform.SkinList;
import org.tizen.emulator.manager.platform.StandardPlatformImageValue;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.plugin.EMPlugin;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.type.Architecture;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class StandardPlatform
extends Platform {
    private Architecture cpu;
    private SKIN_SHAPE skinShape;
    private String binaryVersion;
    private final EMPlugin plugin;
    private List<Skin> skinList = null;
    private VMProperty defaultProperty = null;

    StandardPlatform(StandardPlatformImageValue value, EMPlugin plugin) {
        super(value.getImageFormat());
        this.plugin = plugin;
        this.setValue(value);
    }

    private void setValue(StandardPlatformImageValue value) {
        this.setImageName(value.getName());
        for (String path : value.getPathList()) {
            this.addImagePath(path);
        }
        this.setImageType(value.getType());
        this.setImageDescription(value.getDescription());
        this.cpu = value.getArchitecture();
        this.skinShape = value.getSkinShape();
        this.binaryVersion = value.getBinaryVersion();
        String name = this.plugin.getPluginName();
        if (!this.skinShape.equals((Object)SKIN_SHAPE.SQUARE)) {
            name = name + "-" + this.skinShape.toString();
        }
        if (value.getVersion().equals("3.0")) {
            name = name + "-" + this.cpu.toString();
        }
        this.setName(name);
    }

    @Override
    public String getPlatformPath() {
        return this.plugin.getPlatformPath();
    }

    @Override
    public Profile getProfile() {
        return this.plugin.getProfile();
    }

    @Override
    public Version getVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public String getExtension() {
        return this.plugin.getExtension();
    }

    @Override
    public String getEmulatorDirPath() {
        return this.plugin.getEmulatorDir();
    }

    @Override
    public Architecture getImageArch() {
        return this.cpu;
    }

    @Override
    public SKIN_SHAPE getImageSkinShape() {
        return this.skinShape;
    }

    @Override
    public String getImageBinaryVersion() {
        return this.binaryVersion;
    }

    @Override
    public EMPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public List<Skin> getSkinList() {
        if (this.skinList == null) {
            this.skinList = this.loadSkins();
        }
        return this.skinList;
    }

    @Override
    public Skin getSkinByPath(String path) {
        return SkinList.findSkinByPath(path, this.getSkinList());
    }

    @Override
    public Skin getSkinByName(String name) {
        return SkinList.findSkinByName(name, this.getSkinList());
    }

    @Override
    public List<Skin> getSkinList(RESOLUTION resolution) {
        return SkinList.findSkinList(resolution, this.getSkinList());
    }

    @Override
    public Skin getAvailableSkin(RESOLUTION resolution) {
        List<Skin> list = this.getSkinList(resolution);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        if (!this.skinList.isEmpty()) {
            return this.skinList.get(0);
        }
        return null;
    }

    @Override
    public VMProperty getDefaultProperty() {
        if (this.defaultProperty == null) {
            this.defaultProperty = VMKeeper.loadProperty(this.getImageName(), this);
            if (this.defaultProperty == null) {
                // empty if block
            }
        }
        return this.defaultProperty;
    }

    private List<Skin> loadSkins() {
        File dir = new File(this.getPlatformPath() + File.separator + FilePathResources.getPlatformSkinsSuffix());
        this.skinList = new ArrayList<Skin>();
        if (dir.exists()) {
            File[] fileList = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (fileList != null) {
                for (File skin : fileList) {
                    Skin s = null;
                    try {
                        s = new Skin(skin);
                    }
                    catch (IOException e) {
                        EMLogger.getLogger().warning("Failed adding Skin.." + StringResources.NEW_LINE + "Skin Path: " + skin.getAbsolutePath() + StringResources.NEW_LINE + "Error: " + e.getMessage());
                        continue;
                    }
                    if (!s.getSkinShapeList().hasShape(this.skinShape)) continue;
                    this.skinList.add(s);
                }
            }
        } else {
            EMLogger.getLogger().info("This Skin path does not exist (" + dir.getPath() + ")");
        }
        this.skinList = SkinList.sortForPriority(this.skinList);
        return this.skinList;
    }
}

