/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.ListChangeListener;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.monitor.ECSMonitor;
import org.tizen.emulator.manager.vms.monitor.FileWatcher;
import org.tizen.emulator.manager.vms.monitor.PosixLockFileMonitor;
import org.tizen.emulator.manager.vms.monitor.WindowsLockFileMonitor;

public abstract class RunningMonitor
implements ListChangeListener<VMProperty> {
    private static boolean initialized = false;
    private static Map<VMProperty, MonitoringType> monitoredVMs = Collections.synchronizedMap(new HashMap());

    protected RunningMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPropertyState(VMProperty property) {
        Map<VMProperty, MonitoringType> map = monitoredVMs;
        synchronized (map) {
            if (monitoredVMs.containsKey(property)) {
                return;
            }
            if (property.getState() != VMProperty.State.READY) {
                property.setState(VMProperty.State.READY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateState(VMProperty property, boolean isRunningDetected, MonitoringType type) {
        VMProperty.State updateState;
        Map<VMProperty, MonitoringType> map = monitoredVMs;
        synchronized (map) {
            if (isRunningDetected) {
                if (monitoredVMs.containsKey(property)) {
                    return;
                }
                monitoredVMs.put(property, type);
            } else {
                if (monitoredVMs.get(property) != type) {
                    return;
                }
                monitoredVMs.remove(property);
            }
        }
        VMProperty.State state = updateState = isRunningDetected ? VMProperty.State.RUNNING : VMProperty.State.READY;
        if (property.getState() != updateState) {
            property.setState(updateState);
        }
    }

    public static synchronized void initialize() throws IOException {
        assert (FileWatcher.instance != null);
        assert (!initialized);
        if (OSUtil.isWin()) {
            new WindowsLockFileMonitor();
        } else {
            new PosixLockFileMonitor();
        }
        new ECSMonitor();
        initialized = true;
    }

    static enum MonitoringType {
        ECS,
        LOCK_FILE;

    }
}

