/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.bind.JAXBException;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.monitor.FileAssetsMonitor;
import org.tizen.emulator.manager.vms.monitor.FileWatcher;
import org.tizen.emulator.manager.vms.monitor.RunningMonitor;
import org.tizen.emulator.manager.vms.monitor.VMAvailabilityMonitor;

public class ManagedVMKeeper
extends VMKeeper {
    private final ManagedLinkedQueue properties = new ManagedLinkedQueue();

    @Override
    public void initialize() {
        try {
            FileWatcher.initialize();
            FileAssetsMonitor.initialize();
            VMAvailabilityMonitor.initialize();
            RunningMonitor.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMProperty getProperty(String name) {
        ManagedLinkedQueue managedLinkedQueue = this.properties;
        synchronized (managedLinkedQueue) {
            for (VMProperty property : this.properties) {
                if (!name.equals(property.getPropertyValue().vmName)) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    public Queue<VMProperty> getProperties() {
        return this.properties;
    }

    public synchronized void addVM(Path propertyFilePath) {
        assert (Files.isRegularFile(propertyFilePath, new LinkOption[0]));
        for (VMProperty prop : this.properties) {
            if (!prop.getPropertyFile().equals(propertyFilePath)) continue;
            return;
        }
        VMProperty property = this.loadProperty(propertyFilePath);
        if (property == null || property.getPropertyValue().getPlatform() == null) {
            return;
        }
        assert (property.getHealth() != VMProperty.Health.CORRUPTED && !this.properties.contains(property));
        this.properties.add(property);
    }

    public synchronized void removeVM(Path propertyFilePath) {
        VMProperty property = this.getProperty(propertyFilePath);
        if (property == null) {
            return;
        }
        assert (this.properties.contains(property));
        this.properties.remove(property);
    }

    public synchronized void refreshAll() {
        for (VMProperty property : this.properties) {
            this.listChanged(property, VMKeeper.ChangeType.MODIFIED);
        }
    }

    public synchronized void refreshVM(Path propertyFilePath) {
        VMProperty property = this.getProperty(propertyFilePath);
        assert (property != null);
        this.properties.refresh(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMProperty getProperty(Path propertyFilePath) {
        ManagedLinkedQueue managedLinkedQueue = this.properties;
        synchronized (managedLinkedQueue) {
            for (VMProperty property : this.properties) {
                if (!property.getPropertyFile().equals(propertyFilePath)) continue;
                return property;
            }
        }
        return null;
    }

    class ManagedLinkedQueue
    extends ConcurrentLinkedQueue<VMProperty> {
        private static final long serialVersionUID = 2875465994798102042L;

        ManagedLinkedQueue() {
        }

        @Override
        public synchronized boolean add(VMProperty object) {
            if (super.add(object)) {
                ManagedVMKeeper.this.listChanged(object, VMKeeper.ChangeType.ADDED);
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean remove(Object object) {
            if (super.remove(object)) {
                ManagedVMKeeper.this.listChanged((VMProperty)object, VMKeeper.ChangeType.REMOVED);
                return true;
            }
            return false;
        }

        public synchronized void refresh(VMProperty object) {
            object.refresh();
            ManagedVMKeeper.this.listChanged(object, VMKeeper.ChangeType.MODIFIED);
        }
    }
}

