/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.emulator.manager.logging.EMLogger;

final class ECSSocket {
    private final int ecs_port;
    private final ByteBuffer buffer;
    private SocketChannel socket;
    private Path imagePath;
    private boolean isMonitored;
    private int remainingDataSize = 0;
    private final ByteBuffer recvBuffer = ByteBuffer.allocate(4096);

    ECSSocket(int port) {
        this.ecs_port = port;
        this.buffer = ByteBuffer.allocate(1024);
        this.reset();
    }

    public int getRemainingDataSize() {
        return this.remainingDataSize;
    }

    public void setRemainingDataSize(int size) {
        this.remainingDataSize = size;
    }

    public ByteBuffer getRecvBuffer() {
        return this.recvBuffer;
    }

    void setPath(Path path) {
        this.imagePath = path;
    }

    Path getPath() {
        return this.imagePath;
    }

    SocketChannel getSocket() {
        return this.socket;
    }

    boolean tryConnect() {
        try {
            this.socket = SocketChannel.open();
            this.socket.configureBlocking(false);
            return this.socket.connect(new InetSocketAddress("localhost", this.ecs_port));
        }
        catch (IOException e) {
            this.disconnect();
            return false;
        }
    }

    void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                EMLogger.getLogger().info(e.getMessage());
            }
            this.socket = null;
        }
        this.remainingDataSize = 0;
    }

    boolean sendDeviceReq() {
        EMLogger.getLogger().info("send ecs message : " + this.ecs_port);
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.DEVICE_REQ);
        Ecs.DeviceReq.Builder deviceBuilder = Ecs.DeviceReq.newBuilder();
        deviceBuilder.setCategory("info");
        deviceBuilder.setLength(0);
        deviceBuilder.setGroup(1);
        deviceBuilder.setAction(1);
        masterBuilder.setDeviceReq(deviceBuilder);
        Ecs.Master master = masterBuilder.build();
        return this.sendMaster(master);
    }

    boolean sendKeepAliveAns() {
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.KEEPALIVE_ANS);
        Ecs.KeepAliveAns.Builder kaBuilder = Ecs.KeepAliveAns.newBuilder();
        kaBuilder.setTimeStr("self");
        masterBuilder.setKeepaliveAns(kaBuilder);
        Ecs.Master master = masterBuilder.build();
        return this.sendMaster(master);
    }

    private boolean sendMaster(Ecs.Master master) {
        int serialize_size = master.getSerializedSize();
        try {
            this.buffer.clear();
            this.buffer.putInt(serialize_size);
            this.buffer.put(master.toByteArray());
            this.buffer.position(4 + serialize_size);
            this.buffer.flip();
            this.buffer.position(0);
            this.socket.write(this.buffer);
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Send to ECS fail [port : " + this.ecs_port + "]." + e.getMessage());
            return false;
        }
        return true;
    }

    public void setMonitored(boolean isMonitored) {
        this.isMonitored = isMonitored;
    }

    public boolean isMonitored() {
        return this.isMonitored;
    }

    public void reset() {
        this.imagePath = null;
        this.isMonitored = false;
    }

    static enum ResultType {
        LAUNCHED_VM_DETECTED,
        ECS_NOT_READY,
        IMAGEPATH_NOT_READY,
        SOCK_CLOSED,
        HEARTBEAT;

    }
}

