/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.tizen.emulator.manager.vms.monitor.FileWatcher;

public class FileAlterationMonitorFileWatcher
extends FileWatcher {
    final long pollingInterval = 500L;
    final FileAlterationMonitor monitor = new FileAlterationMonitor(500L);

    protected FileAlterationMonitorFileWatcher() throws IOException {
    }

    private final FileAlterationListener fileAlterationListener() {
        return new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                FileAlterationMonitorFileWatcher.this.fileCreated(file.toPath());
            }

            public void onFileChange(File file) {
                FileAlterationMonitorFileWatcher.this.fileModified(file.toPath());
            }

            public void onFileDelete(File file) {
                FileAlterationMonitorFileWatcher.this.fileDeleted(file.toPath());
            }

            public void onDirectoryCreate(File file) {
                FileAlterationMonitorFileWatcher.this.directoryCreated(file.toPath());
            }

            public void onDirectoryChange(File file) {
                FileAlterationMonitorFileWatcher.this.directoryModified(file.toPath());
            }

            public void onDirectoryDelete(File file) {
                FileAlterationMonitorFileWatcher.this.directoryDeleted(file.toPath());
            }
        };
    }

    @Override
    protected void registerWatchRoot(Path path) {
        FileAlterationObserver fao = new FileAlterationObserver(path.toFile());
        fao.addListener(this.fileAlterationListener());
        this.monitor.addObserver(fao);
    }

    @Override
    protected void registerDirectoryInternal(Path path) throws IOException {
    }

    @Override
    protected void monitoring() throws IOException, InterruptedException {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

