/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;

public class VMRunningChecker {
    public static boolean isRunning(VMProperty property) throws IOException {
        boolean isExist = false;
        if (property.getHealth() == VMProperty.Health.CORRUPTED) {
            return false;
        }
        if (!OSUtil.isWin()) {
            Path lockfile = Paths.get(property.getPropertyValue().getLockFilePath(), new String[0]);
            assert (Files.isRegularFile(lockfile, new LinkOption[0]) && Files.isWritable(lockfile));
            FileChannel fc = null;
            try {
                fc = FileChannel.open(lockfile, StandardOpenOption.READ);
            }
            catch (NoSuchFileException e) {
                EMLogger.getLogger().info("A lock file does not exist. Maybe, a vm was removed.");
                return false;
            }
            FileLock lock = fc.tryLock(0L, 1L, true);
            if (lock != null && lock.isValid()) {
                lock.release();
                fc.close();
                return false;
            }
            fc.close();
            return true;
        }
        isExist = new File(property.getPropertyValue().getLockFilePath() + ".lock").exists();
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunningProcess(VMProperty property) throws IOException {
        boolean result = false;
        Process p = null;
        InputStreamReader inputReader = null;
        BufferedReader stdOut = null;
        try {
            String line;
            p = VMRunningChecker.makeCheckingProcess();
            if (p == null) {
                boolean bl = false;
                return bl;
            }
            inputReader = new InputStreamReader(p.getInputStream());
            stdOut = new BufferedReader(inputReader);
            while ((line = stdOut.readLine()) != null) {
                String re = VMRunningChecker.isRunning(line, property);
                if (re == null) continue;
                EMLogger.getLogger().log(Level.INFO, "emulator instance with the same name is running now (" + re + ")");
                result = true;
                break;
            }
            boolean re = result;
            return re;
        }
        catch (IOException err) {
            EMLogger.getLogger().log(Level.SEVERE, "Error occurred while checking if the same VM." + StringResources.NEW_LINE + err.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (stdOut != null) {
                try {
                    stdOut.close();
                }
                catch (IOException e) {
                    EMLogger.getLogger().log(Level.WARNING, e.getMessage());
                }
            }
            if (inputReader != null) {
                try {
                    inputReader.close();
                }
                catch (IOException e) {
                    EMLogger.getLogger().log(Level.WARNING, e.getMessage());
                }
            }
        }
    }

    private static String isRunning(String line, VMProperty prop) {
        String vmLaunchConfPath = FilePathResources.getVirtualTargetLaunchConfPath(prop.getPropertyValue().vmName);
        if (line.contains(vmLaunchConfPath)) {
            return vmLaunchConfPath;
        }
        return null;
    }

    private static Process makeCheckingProcess() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (OSUtil.isLinux()) {
            cmd.add("/bin/bash");
            cmd.add("-c");
            cmd.add("/bin/ps -ef | grep emulator-x86");
        } else if (OSUtil.isWin()) {
            cmd.add("cmd.exe");
            cmd.add("/c");
            cmd.add("wmic path win32_process get commandline | findstr emulator-x86");
        } else if (OSUtil.isMac()) {
            cmd.add("/bin/bash");
            cmd.add("-c");
            cmd.add("/bin/ps -ef | grep emulator-x86");
        }
        ProcessBuilder pb = null;
        Process p = null;
        pb = new ProcessBuilder(cmd);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            EMLogger.getLogger().log(Level.SEVERE, "Error occurred while checking if the same VM." + StringResources.NEW_LINE + e.getMessage());
            return null;
        }
        return p;
    }
}

