/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableView;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.item.VMItem;

class TableSelectionListener
implements ListChangeListener<Integer> {
    private final TableView<VMItem> table;
    private static SimpleBooleanProperty disableModify = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableDelete = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableDetail = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableReset = new SimpleBooleanProperty(true);

    public TableSelectionListener(TableView<VMItem> vmTable) {
        this.table = vmTable;
    }

    static SimpleBooleanProperty getDisableModify() {
        return disableModify;
    }

    static SimpleBooleanProperty getDisableDelete() {
        return disableDelete;
    }

    static SimpleBooleanProperty getDisableDetail() {
        return disableDetail;
    }

    static SimpleBooleanProperty getDisableReset() {
        return disableReset;
    }

    public void onChanged(ListChangeListener.Change<? extends Integer> change) {
        ObservableList selectedItems = this.table.getSelectionModel().getSelectedItems();
        int count = selectedItems.size();
        for (VMItem item : this.table.getItems()) {
            if (item.getRowState().get() != ROW_STATE.SELECTED) continue;
            item.setRowState(ROW_STATE.NORMAL);
            item.setChecked(false);
        }
        for (VMItem item : selectedItems) {
        }
        for (VMItem item : selectedItems) {
            item.setRowState(ROW_STATE.SELECTED);
            item.setChecked(true);
        }
        if (count == 0) {
            disableModify.set(true);
            disableDelete.set(true);
            disableDetail.set(true);
            disableReset.set(true);
        } else if (count == 1) {
            VMItem item = (VMItem)selectedItems.get(0);
            if (item.isRunning()) {
                disableDetail.set(false);
                disableModify.set(true);
                disableDelete.set(true);
                disableReset.set(true);
            } else if (item.isNotAvailable()) {
                disableDelete.set(false);
                disableModify.set(true);
                disableReset.set(true);
                disableDetail.set(true);
            } else {
                disableModify.set(false);
                disableDelete.set(false);
                disableReset.set(false);
                disableDetail.set(false);
            }
        } else {
            boolean isRunning = false;
            boolean isNotAvailable = false;
            for (VMItem item : selectedItems) {
                if (item.isRunning()) {
                    isRunning = true;
                }
                if (!item.isNotAvailable()) continue;
                isNotAvailable = true;
            }
            if (isRunning) {
                disableDetail.set(false);
                disableModify.set(true);
                disableDelete.set(true);
                disableReset.set(true);
            } else if (isNotAvailable) {
                disableDelete.set(false);
                disableModify.set(true);
                disableReset.set(true);
                disableDetail.set(true);
            } else {
                disableDelete.set(false);
                disableReset.set(false);
                disableModify.set(true);
                disableDetail.set(true);
            }
        }
    }
}

