/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms.filter;

import com.sun.javafx.css.StyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class FilterPopupBakup
extends PopupControl {
    private final SimpleStringProperty title;
    private final SimpleObjectProperty<Button> saveButton;
    private final SimpleObjectProperty<Button> cancelButton;
    private final ObjectProperty<Node> contentNode = new SimpleObjectProperty();
    private static final String TOGGLE_ALL = "All Selection";
    private final CheckBox toggleAllChbx = new CheckBox("All Selection");
    private boolean selectedByDefault = true;
    private final boolean showToggle = true;
    private boolean[] previousSelections;
    private final ObservableList<CheckBox> enumCombos;
    private SimpleBooleanProperty filtered;
    private static int BUTTON_HEIGHT = 30;
    private static int BUTTON_WIDTH = 72;
    private static int ROW_HEIGHT = 26;
    private static int POPUP_WIDTH = 145;

    public List<String> getFilterList() {
        ArrayList<String> filters = new ArrayList<String>();
        for (CheckBox box : this.enumCombos) {
            if (!box.isSelected() || box.getText().equals(TOGGLE_ALL)) continue;
            filters.add(box.getText());
        }
        return filters;
    }

    public FilterPopupBakup(String title) {
        this.setHideOnEscape(true);
        this.setAutoHide(true);
        EventHandler<KeyEvent> cancelEvent = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    FilterPopupBakup.this.hide();
                }
            }
        };
        this.title = new SimpleStringProperty(title);
        Button sButton = new Button("OK");
        this.saveButton = new SimpleObjectProperty((Object)sButton);
        sButton.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)cancelEvent);
        sButton.setDefaultButton(true);
        sButton.setPrefSize((double)BUTTON_WIDTH, (double)BUTTON_HEIGHT);
        Button cButton = new Button("Cancel");
        this.cancelButton = new SimpleObjectProperty((Object)cButton);
        cButton.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)cancelEvent);
        cButton.setCancelButton(true);
        cButton.setPrefSize((double)BUTTON_WIDTH, (double)BUTTON_HEIGHT);
        cButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FilterPopupBakup.this.hide();
            }
        });
        StyleManager.getInstance().addUserAgentStylesheet(((Object)((Object)this)).getClass().getResource("/view/filterPopup.css").toExternalForm());
        this.getStyleClass().setAll((Object[])new String[]{"filter-popup-menu"});
        this.setSkin(new FilterMenuPopupSkin2());
        this.enumCombos = FXCollections.observableArrayList();
    }

    public SimpleStringProperty titleProperty() {
        return this.title;
    }

    public ObjectProperty<Node> contentNodeProperty() {
        return this.contentNode;
    }

    public final Node getContentNode() {
        return (Node)this.contentNode.get();
    }

    public Button getSaveButton() {
        return (Button)this.saveButton.get();
    }

    public SimpleObjectProperty<Button> cancelButtonProperty() {
        return this.saveButton;
    }

    public Button getCancelButton() {
        return (Button)this.cancelButton.get();
    }

    public void setSaveEvent(EventHandler<ActionEvent> event) {
        ((Button)this.saveButton.get()).setOnAction(event);
    }

    public final void populateMenuItems(Map<String, Boolean> values) {
        int len = values == null ? 0 : values.size();
        this.enumCombos.clear();
        if (values != null) {
            this.toggleAllChbx.setPrefHeight((double)ROW_HEIGHT);
            this.toggleAllChbx.setSelected(this.selectedByDefault);
            this.toggleAllChbx.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    FilterPopupBakup.this.toggleAll(FilterPopupBakup.this.toggleAllChbx.isSelected());
                    t.consume();
                }
            });
            this.showToggleAll(true);
            final SimpleIntegerProperty itemsChecked = new SimpleIntegerProperty();
            itemsChecked.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    int itemsSel = newValue.intValue();
                    if (itemsSel == 0) {
                        FilterPopupBakup.this.toggleAllChbx.setSelected(false);
                        FilterPopupBakup.this.toggleAllChbx.setIndeterminate(false);
                    } else if (itemsSel == FilterPopupBakup.this.enumCombos.size() - 1) {
                        FilterPopupBakup.this.toggleAllChbx.setSelected(true);
                        FilterPopupBakup.this.toggleAllChbx.setIndeterminate(false);
                    } else {
                        FilterPopupBakup.this.toggleAllChbx.setIndeterminate(true);
                    }
                }
            });
            for (String profile : values.keySet()) {
                final CheckBox ecb = new CheckBox(profile);
                ecb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        int currVal = itemsChecked.getValue();
                        itemsChecked.set(ecb.isSelected() ? currVal + 1 : currVal - 1);
                    }
                });
                ecb.setUserData((Object)profile);
                ecb.setSelected(values.get(profile).booleanValue());
                ecb.setPrefHeight((double)ROW_HEIGHT);
                this.enumCombos.add((Object)ecb);
            }
        }
        final ListView list = new ListView(this.enumCombos);
        list.setEditable(false);
        list.setMaxHeight(215.0);
        list.setMaxWidth(400.0);
        list.setPrefWidth((double)POPUP_WIDTH);
        list.setPrefHeight((double)((ROW_HEIGHT + 7) * Math.max(this.enumCombos.size(), 2)));
        list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    list.getScene().getWindow().hide();
                }
            }
        });
        list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CheckBox cb = (CheckBox)list.getSelectionModel().getSelectedItem();
                if (cb != null) {
                    cb.setSelected(!cb.isSelected());
                    cb.requestFocus();
                }
            }
        });
        this.contentNode.set((Object)list);
    }

    public void cancel() {
        int i = 0;
        for (CheckBox emu : this.enumCombos) {
            emu.setSelected(this.previousSelections[i++]);
        }
    }

    public boolean save() throws Exception {
        CheckBox emu;
        int i;
        boolean changed = false;
        boolean noSelections = true;
        for (i = 0; i < this.enumCombos.size(); ++i) {
            emu = (CheckBox)this.enumCombos.get(i);
            if (emu.isSelected() == this.selectedByDefault) continue;
            noSelections = false;
            break;
        }
        if (noSelections) {
            changed = this.clear();
        } else {
            this.setFiltered(true);
            for (i = 0; i < this.enumCombos.size(); ++i) {
                emu = (CheckBox)this.enumCombos.get(i);
                if (this.previousSelections[i] == emu.isSelected()) continue;
                changed = true;
                break;
            }
            for (i = 0; i < this.enumCombos.size(); ++i) {
                emu = (CheckBox)this.enumCombos.get(i);
                this.previousSelections[i] = emu.isSelected();
            }
        }
        return changed;
    }

    public boolean clear() throws Exception {
        boolean changed = false;
        for (int i = 0; i < this.previousSelections.length; ++i) {
            this.previousSelections[i] = this.selectedByDefault;
        }
        for (CheckBox emu : this.enumCombos) {
            emu.setSelected(this.selectedByDefault);
        }
        if (this.isFiltered()) {
            this.setFiltered(false);
            changed = true;
        }
        return changed;
    }

    public void selectedByDefault(boolean selected) {
        this.selectedByDefault = selected;
    }

    public void toggleAll(boolean selected) {
        for (int i = 0; i < this.enumCombos.size(); ++i) {
            CheckBox ecb = (CheckBox)this.enumCombos.get(i);
            ecb.setSelected(selected);
        }
    }

    public void showToggleAll(boolean showToggle) {
        if (showToggle) {
            if (this.enumCombos.isEmpty() || this.enumCombos.get(0) != this.toggleAllChbx) {
                this.enumCombos.add(0, (Object)this.toggleAllChbx);
            }
        } else if (!this.enumCombos.isEmpty() && this.enumCombos.get(0) == this.toggleAllChbx) {
            this.enumCombos.remove(0);
        }
    }

    public boolean isFiltered() {
        return this.filtered.get();
    }

    protected void setFiltered(boolean isFiltered) {
        this.filtered.set(isFiltered);
    }

    private class FilterMenuPopupSkin2
    extends StackPane
    implements Skin<FilterPopupBakup> {
        public FilterMenuPopupSkin2() {
            ContentStack contentStack = new ContentStack();
            this.getChildren().add((Object)contentStack);
            this.idProperty().bind((ObservableValue)FilterPopupBakup.this.idProperty());
            this.styleProperty().bind((ObservableValue)FilterPopupBakup.this.styleProperty());
            this.getStyleClass().setAll((Collection)FilterPopupBakup.this.getStyleClass());
        }

        public FilterPopupBakup getSkinnable() {
            return FilterPopupBakup.this;
        }

        public Node getNode() {
            return this;
        }

        public void dispose() {
            this.getChildren().clear();
        }

        class ContentStack
        extends BorderPane {
            public ContentStack() {
                this.getStyleClass().add((Object)"content");
                FilterPopupBakup.this.contentNodeProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                    public void changed(ObservableValue<? extends Node> paramObservableValue, Node paramT1, Node paramT2) {
                        paramT2.getStyleClass().add((Object)"center");
                        ContentStack.this.setCenter(paramT2);
                    }
                });
                if (FilterPopupBakup.this.getContentNode() != null) {
                    FilterPopupBakup.this.getContentNode().getStyleClass().add((Object)"center");
                }
                this.setCenter(FilterPopupBakup.this.getContentNode());
                HBox buttons = new HBox();
                buttons.setPrefWidth(-1.0);
                buttons.setPrefHeight(-1.0);
                buttons.setSpacing(4.0);
                buttons.getChildren().addAll((Object[])new Node[]{FilterPopupBakup.this.getCancelButton(), FilterPopupBakup.this.getSaveButton()});
                VBox bottom = new VBox();
                bottom.getStyleClass().add((Object)"bottom");
                bottom.getChildren().addAll((Object[])new Node[]{buttons});
                this.setBottom((Node)bottom);
            }
        }
    }
}

