/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.devicetemplate.controller;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.tizen.emulator.manager.EmulatorManagerMode;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.devicetemplate.item.ResolutionViewItem;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;
import org.tizen.emulator.manager.vms.type.RESOLUTION;

public class ResolutionViewController
extends ViewItemController {
    List<RESOLUTION> resList;
    private RESOLUTION resolution;
    private ResolutionViewItem resolutionViewItem;
    boolean isCustomResolution = false;
    private static final String CUSTOM_TEXT = "(custom)";

    public ResolutionViewController(Item item) {
        super(item);
        this.resList = ResolutionViewController.getResolutionList(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new ResolutionViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.resolutionViewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        if (item instanceof ResolutionViewItem) {
            this.resolutionViewItem = (ResolutionViewItem)item;
        }
        if (this.resolutionViewItem == null) {
            return;
        }
        this.resolutionViewItem.setTitle(this.getTitle());
        this.initCombo();
        this.addListener();
    }

    private void addListener() {
        this.resolutionViewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                ResolutionViewController.this.selectedItem(event);
            }
        });
        this.resolutionViewItem.setOnWidthChanged(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                String displayWidth = ResolutionViewController.removeBeginningZero(arg2);
                if (!displayWidth.equals(arg2)) {
                    ResolutionViewController.this.resolutionViewItem.setWidth(displayWidth);
                }
                ResolutionViewController.this.checkCustomResolution();
            }
        });
        this.resolutionViewItem.setOnHeightChanged(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                String displayHeight = ResolutionViewController.removeBeginningZero(arg2);
                if (!displayHeight.equals(arg2)) {
                    ResolutionViewController.this.resolutionViewItem.setHeight(displayHeight);
                }
                ResolutionViewController.this.checkCustomResolution();
            }
        });
    }

    private void checkCustomResolution() {
        if (!this.checkDisplayResolution()) {
            return;
        }
        String displayWidth = this.resolutionViewItem.getWidth();
        String displayHeight = this.resolutionViewItem.getHeight();
        int width = Integer.parseInt(displayWidth);
        int height = Integer.parseInt(displayHeight);
        for (RESOLUTION res : this.resList) {
            if (width != res.getWidth() || height != res.getHeight()) continue;
            if (!this.isCustomResolution) {
                return;
            }
            this.resolution = res;
            this.setCustomResolution(false);
            return;
        }
        this.setCustomResolution(true);
    }

    private void setCustomResolution(boolean isCustom) {
        this.isCustomResolution = isCustom;
        if (isCustom) {
            this.resolutionViewItem.addItem(CUSTOM_TEXT, true);
            this.resolutionViewItem.selectItem(CUSTOM_TEXT);
        } else {
            this.selectResolutionCombo();
        }
    }

    private boolean checkDisplayResolution() {
        String displayWidth = this.resolutionViewItem.getWidth();
        String displayHeight = this.resolutionViewItem.getHeight();
        if (displayWidth.isEmpty() || displayHeight.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(displayWidth);
            Integer.parseInt(displayHeight);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String removeBeginningZero(String numeric) {
        StringBuffer sb = new StringBuffer(numeric);
        if (sb.length() != 0 && sb.charAt(0) == '0') {
            return ResolutionViewController.removeBeginningZero(sb.substring(1, sb.length()));
        }
        return sb.toString();
    }

    private void initCombo() {
        for (RESOLUTION res : this.resList) {
            this.resolutionViewItem.addItem(res.toString());
        }
    }

    protected void selectedItem(Event event) {
        String re = this.resolutionViewItem.getSelectedItem();
        if (re.equals(CUSTOM_TEXT)) {
            return;
        }
        RESOLUTION d = null;
        for (RESOLUTION r : this.resList) {
            if (!re.equals(r.toString())) continue;
            d = r;
        }
        if (d != null) {
            this.resolution = d;
        }
        ItemEvent iEvent = new ItemEvent(this.getName());
        iEvent.data = this.resolution;
        ViewItemController.sendChangeEvent(iEvent);
        this.resolutionViewItem.setResolution(this.resolution);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.resolution = (RESOLUTION)value.getObjectValue(this.getName());
        this.selectResolutionCombo();
    }

    private void selectResolutionCombo() {
        String re = null;
        if (this.resolution != null) {
            re = this.resolution.toString();
        } else if (this.resList.size() > 0) {
            re = this.resList.get(0).toString();
        } else {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.resolutionViewItem.getItemList().size(); ++i) {
            String str = this.resolutionViewItem.getItemList().get(i);
            if (!str.equals(re)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            this.resList.add(0, this.resolution);
            this.resolutionViewItem.addItem(this.resolution.toString(), 0);
            index = 0;
        }
        this.resolutionViewItem.selectItem(index);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.isCustomResolution) {
            this.resolution = new RESOLUTION(Integer.valueOf(this.resolutionViewItem.getWidth()), Integer.valueOf(this.resolutionViewItem.getHeight()), "", 0);
        }
        value.setObjectValue(this.getName(), this.resolution);
    }

    @Override
    public void checkValid() {
    }

    private static List<RESOLUTION> getResolutionList(Item displayItem) {
        ArrayList<RESOLUTION> list = new ArrayList<RESOLUTION>();
        for (Option opt : displayItem.getOptions()) {
            String[] split;
            if (ResolutionViewController.checkExperimentalOption(opt) || (split = opt.getValue().split(",")).length != 4) continue;
            RESOLUTION resolution = null;
            for (String s : split) {
                try {
                    String name = split[0].trim();
                    int width = Integer.parseInt(split[1].trim());
                    int height = Integer.parseInt(split[2].trim());
                    int dpi = Integer.parseInt(split[3].trim());
                    resolution = new RESOLUTION(width, height, name, dpi);
                }
                catch (NumberFormatException e) {
                    EMLogger.getLogger().warning("Failed to parse Resolution : " + s);
                }
            }
            if (resolution == null) continue;
            list.add(resolution);
        }
        return list;
    }

    public static boolean checkExperimentalOption(Option option) {
        String attr = option.getAttr();
        return attr.equals("experimental") && !EmulatorManagerMode.isInhouseMode();
    }

    @Override
    protected void onChangedValue(Event event) {
    }
}

