/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class FileViewItem
extends ViewItem {
    protected static File DEFAULT_INITIAL_PATH = null;
    private Type type = Type.FILE;
    private FileChooser fileChooser;
    private DirectoryChooser directoryChooser;
    protected final HBox box;
    private final TextField labDirName;
    private final Button btnOpenChooser;
    private File selectedFile;
    private String dialogTitle = "Select";
    private File initialDir = null;
    private final List<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();

    public FileViewItem() {
        this.makeChooser();
        if (DEFAULT_INITIAL_PATH == null) {
            DEFAULT_INITIAL_PATH = new File(FilePathResources.getTizenSDKDataPath());
        }
        this.box = new HBox();
        this.box.setAlignment(Pos.CENTER_RIGHT);
        this.labDirName = new TextField();
        this.labDirName.getStyleClass().add((Object)"label-text-field");
        this.labDirName.setEditable(false);
        this.btnOpenChooser = new Button();
        this.btnOpenChooser.setGraphic((Node)new ImageView(Images.get(ImageKind.BTN_IC_PATH)));
        this.btnOpenChooser.setPrefHeight(24.0);
        this.box.getChildren().add((Object)this.labDirName);
        this.box.getChildren().add((Object)this.btnOpenChooser);
        HBox.setHgrow((Node)this.labDirName, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.btnOpenChooser, (Priority)Priority.NEVER);
        HBox.setMargin((Node)this.btnOpenChooser, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.baseView.setPrefHeight(28.0);
        this.baseView.setViewItem((Node)this.box);
        this.addListener();
    }

    private void addListener() {
        this.btnOpenChooser.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                File file = null;
                if (FileViewItem.this.type == Type.DIR) {
                    if (FileViewItem.this.initialDir != null) {
                        FileViewItem.this.directoryChooser.setInitialDirectory(FileViewItem.this.initialDir);
                    } else {
                        FileViewItem.this.directoryChooser.setInitialDirectory(DEFAULT_INITIAL_PATH);
                    }
                    FileViewItem.this.directoryChooser.setTitle(FileViewItem.this.dialogTitle);
                    file = FileViewItem.this.directoryChooser.showDialog((Window)Main.getPrimaryStage());
                } else if (FileViewItem.this.type == Type.FILE) {
                    if (FileViewItem.this.initialDir != null) {
                        FileViewItem.this.fileChooser.setInitialDirectory(FileViewItem.this.initialDir);
                    } else {
                        FileViewItem.this.fileChooser.setInitialDirectory(DEFAULT_INITIAL_PATH);
                    }
                    if (FileViewItem.this.filters != null) {
                        FileViewItem.this.fileChooser.getExtensionFilters().clear();
                        FileViewItem.this.fileChooser.getExtensionFilters().addAll((Collection)FileViewItem.this.filters);
                    }
                    FileViewItem.this.fileChooser.setTitle(FileViewItem.this.dialogTitle);
                    file = FileViewItem.this.fileChooser.showOpenDialog((Window)Main.getPrimaryStage());
                }
                if (file != null) {
                    FileViewItem.this.selectedFile = file;
                    DEFAULT_INITIAL_PATH = file.isDirectory() ? file : file.getParentFile();
                    FileViewItem.this.setFile(file);
                    Event e = new Event(EventType.Selection);
                    e.text = FileViewItem.this.selectedFile.getAbsolutePath();
                    FileViewItem.this.sendEvent(e);
                }
            }
        });
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }

    public void setInitialDirectory(String dir) {
        this.initialDir = new File(dir);
    }

    public void addFilter(String description, String ... extension) {
        this.filters.add(new FileChooser.ExtensionFilter(description, extension));
    }

    public void setButtonText(String text) {
        this.btnOpenChooser.setText(text);
    }

    public void setFile(File file) {
        if (file == null) {
            this.labDirName.setText("");
            this.selectedFile = null;
        } else {
            this.labDirName.setText(file.getName());
            this.labDirName.setTooltip(new Tooltip(file.getAbsolutePath()));
            this.selectedFile = file;
        }
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public String getFileName() {
        if (this.selectedFile != null) {
            return this.selectedFile.getName();
        }
        return "";
    }

    public void setLabelText(String text) {
        this.labDirName.setText(text);
    }

    public String getFilePath() {
        if (this.selectedFile != null) {
            return this.selectedFile.getPath();
        }
        return "";
    }

    @Override
    public String toString() {
        return this.labDirName.getText();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        this.makeChooser();
    }

    private void makeChooser() {
        switch (this.type) {
            case DIR: {
                if (this.directoryChooser != null) {
                    return;
                }
                this.directoryChooser = new DirectoryChooser();
                break;
            }
            case FILE: {
                if (this.fileChooser != null) {
                    return;
                }
                this.fileChooser = new FileChooser();
            }
        }
    }

    @Override
    public void setAsLabel(String path) {
        String fileName = "";
        if (path != null && !path.isEmpty()) {
            fileName = path.substring(path.lastIndexOf(File.separator) + 1, path.length());
        }
        super.setAsLabel(fileName);
        this.setTooltip(path);
    }

    public static enum Type {
        DIR,
        FILE;

    }
}

